/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.query;

import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CosmosPageImpl<T>
extends PageImpl<T> {
    private static final long serialVersionUID = 5294396337522314504L;
    private final long offset;

    public CosmosPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
        this.offset = pageable.getOffset();
    }

    public int getTotalPages() {
        return super.getTotalPages();
    }

    public long getTotalElements() {
        return super.getTotalElements();
    }

    public boolean hasNext() {
        return this.offset + (long)this.getContent().size() < this.getTotalElements();
    }

    public boolean isLast() {
        return super.isLast();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CosmosPageImpl that = (CosmosPageImpl)((Object)o);
        return this.offset == that.offset;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.offset);
    }
}

