/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.Strings;
import com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={CryptographyClient.class})
public final class CryptographyClientBuilder {
    private final ClientLogger logger = new ClientLogger(CryptographyClientBuilder.class);
    private static final String AZURE_KEY_VAULT_KEYS = "azure-key-vault-keys.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> policies;
    private final Map<String, String> properties;
    private Configuration configuration;
    private CryptographyServiceVersion version;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private JsonWebKey jsonWebKey;
    private RetryPolicy retryPolicy;
    private String keyId;
    private TokenCredential credential;

    public CryptographyClientBuilder() {
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_KEYS);
        this.retryPolicy = new RetryPolicy();
    }

    public CryptographyClient buildClient() {
        return new CryptographyClient(this.buildAsyncClient());
    }

    public CryptographyAsyncClient buildAsyncClient() {
        CryptographyServiceVersion serviceVersion;
        if (this.jsonWebKey == null && Strings.isNullOrEmpty(this.keyId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Json Web Key or jsonWebKey identifier are required to create cryptography client"));
        }
        CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.version != null ? this.version : CryptographyServiceVersion.getLatest();
        if (this.pipeline != null) {
            if (this.jsonWebKey != null) {
                return new CryptographyAsyncClient(this.jsonWebKey, this.pipeline, serviceVersion);
            }
            return new CryptographyAsyncClient(this.keyId, this.pipeline, serviceVersion);
        }
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials are required to build the cryptography client if a JSON Web Key is not provided."));
        }
        HttpPipeline pipeline = this.setupPipeline();
        if (this.jsonWebKey != null) {
            return new CryptographyAsyncClient(this.jsonWebKey, pipeline, serviceVersion);
        }
        return new CryptographyAsyncClient(this.keyId, pipeline, serviceVersion);
    }

    HttpPipeline setupPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.add(new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }

    TokenCredential getCredential() {
        return this.credential;
    }

    HttpPipeline getPipeline() {
        return this.pipeline;
    }

    CryptographyServiceVersion getServiceVersion() {
        return this.version;
    }

    public CryptographyClientBuilder keyIdentifier(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public CryptographyClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public CryptographyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CryptographyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        return this;
    }

    public CryptographyClientBuilder httpClient(HttpClient client) {
        if (client == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'client' cannot be null."));
        }
        this.httpClient = client;
        return this;
    }

    public CryptographyClientBuilder pipeline(HttpPipeline pipeline) {
        if (pipeline == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'pipeline' cannot be null."));
        }
        this.pipeline = pipeline;
        return this;
    }

    public CryptographyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CryptographyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.version = version;
        return this;
    }

    public CryptographyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'retryPolicy' cannot be null."));
        }
        this.retryPolicy = retryPolicy;
        return this;
    }
}

