/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.AesKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyService;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.EcKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.RsaKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.Strings;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class CryptographyAsyncClient {
    static final String KEY_VAULT_SCOPE = "https://vault.azure.net/.default";
    static final String SECRETS_COLLECTION = "secrets";
    static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    JsonWebKey key;
    private final ClientLogger logger = new ClientLogger(CryptographyAsyncClient.class);
    private final CryptographyService service;
    private final String keyId;
    private CryptographyServiceClient cryptographyServiceClient;
    private LocalKeyCryptographyClient localKeyCryptographyClient;
    private String keyCollection;

    CryptographyAsyncClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version) {
        this.unpackAndValidateId(keyId);
        this.keyId = keyId;
        this.service = (CryptographyService)RestProxy.create(CryptographyService.class, (HttpPipeline)pipeline);
        this.cryptographyServiceClient = new CryptographyServiceClient(keyId, this.service, version);
        this.key = null;
    }

    CryptographyAsyncClient(JsonWebKey jsonWebKey, HttpPipeline pipeline, CryptographyServiceVersion version) {
        Objects.requireNonNull(jsonWebKey, "The JSON Web Key is required.");
        if (!jsonWebKey.isValid()) {
            throw new IllegalArgumentException("The JSON Web Key is not valid.");
        }
        if (jsonWebKey.getKeyOps() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key operations property is not configured.");
        }
        if (jsonWebKey.getKeyType() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key type property is not configured.");
        }
        this.key = jsonWebKey;
        this.keyId = this.key.getId();
        CryptographyService cryptographyService = this.service = pipeline != null ? (CryptographyService)RestProxy.create(CryptographyService.class, (HttpPipeline)pipeline) : null;
        if (!Strings.isNullOrEmpty(this.key.getId()) && version != null && this.service != null) {
            this.unpackAndValidateId(this.key.getId());
            this.cryptographyServiceClient = new CryptographyServiceClient(this.key.getId(), this.service, version);
        } else {
            this.cryptographyServiceClient = null;
        }
        this.initializeCryptoClients();
    }

    private void initializeCryptoClients() {
        if (this.localKeyCryptographyClient != null) {
            return;
        }
        if (this.key.getKeyType().equals((Object)KeyType.RSA) || this.key.getKeyType().equals((Object)KeyType.RSA_HSM)) {
            this.localKeyCryptographyClient = new RsaKeyCryptographyClient(this.key, this.cryptographyServiceClient);
        } else if (this.key.getKeyType().equals((Object)KeyType.EC) || this.key.getKeyType().equals((Object)KeyType.EC_HSM)) {
            this.localKeyCryptographyClient = new EcKeyCryptographyClient(this.key, this.cryptographyServiceClient);
        } else if (this.key.getKeyType().equals((Object)KeyType.OCT)) {
            this.localKeyCryptographyClient = new AesKeyCryptographyClient(this.key, this.cryptographyServiceClient);
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The JSON Web Key type: %s is not supported.", this.key.getKeyType().toString())));
        }
    }

    Mono<String> getKeyId() {
        return Mono.defer(() -> Mono.just((Object)this.keyId));
    }

    Mono<KeyVaultKey> getKey() {
        try {
            return this.getKeyWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> getKeyWithResponse() {
        try {
            return FluxUtil.withContext(this::getKeyWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> getKeyWithResponse(Context context) {
        return this.cryptographyServiceClient.getKey(context);
    }

    Mono<JsonWebKey> getSecretKey() {
        try {
            return FluxUtil.withContext(context -> this.cryptographyServiceClient.getSecretKey((Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        try {
            return FluxUtil.withContext(context -> this.encrypt(algorithm, plaintext, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plain text content to be encrypted cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.encrypt(algorithm, plaintext, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.ENCRYPT)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Encrypt operation is missing permission/not supported for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.encryptAsync(algorithm, plaintext, context, this.key);
        });
    }

    public Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext) {
        try {
            return FluxUtil.withContext(context -> this.decrypt(algorithm, ciphertext, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] cipherText, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(cipherText, "Cipher text content to be decrypted cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.decrypt(algorithm, cipherText, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.DECRYPT)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Decrypt operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.decryptAsync(algorithm, cipherText, context, this.key);
        });
    }

    public Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest) {
        try {
            return FluxUtil.withContext(context -> this.sign(algorithm, digest, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content to be signed cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.sign(algorithm, digest, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.signAsync(algorithm, digest, context, this.key);
        });
    }

    public Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.verify(algorithm, digest, signature, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(digest, "Digest content cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.verify(algorithm, digest, signature, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.verifyAsync(algorithm, digest, signature, context, this.key);
        });
    }

    public Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        try {
            return FluxUtil.withContext(context -> this.wrapKey(algorithm, key, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.wrapKey(algorithm, key, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.WRAP_KEY)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Wrap Key operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.wrapKeyAsync(algorithm, key, context, this.key);
        });
    }

    public Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        try {
            return FluxUtil.withContext(context -> this.unwrapKey(algorithm, encryptedKey, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.unwrapKey(algorithm, encryptedKey, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.UNWRAP_KEY)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Unwrap Key operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.unwrapKeyAsync(algorithm, encryptedKey, context, this.key);
        });
    }

    public Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data) {
        try {
            return FluxUtil.withContext(context -> this.signData(algorithm, data, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data to be signed cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.signData(algorithm, data, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign Operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.signDataAsync(algorithm, data, context, this.key);
        });
    }

    public Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.verifyData(algorithm, data, signature, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        Objects.requireNonNull(algorithm, "Signature algorithm cannot be null.");
        Objects.requireNonNull(data, "Data cannot be null.");
        Objects.requireNonNull(signature, "Signature to be verified cannot be null.");
        return this.ensureValidKeyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.cryptographyServiceClient.verifyData(algorithm, data, signature, context);
            }
            if (!this.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.verifyDataAsync(algorithm, data, signature, context, this.key);
        });
    }

    private void unpackAndValidateId(String keyId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)keyId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key Id is invalid"));
        }
        try {
            URL url = new URL(keyId);
            String[] tokens = url.getPath().split("/");
            String endpoint = url.getProtocol() + "://" + url.getHost();
            String keyName = tokens.length >= 3 ? tokens[2] : null;
            String version = tokens.length >= 4 ? tokens[3] : null;
            String string = this.keyCollection = tokens.length >= 2 ? tokens[1] : null;
            if (Strings.isNullOrEmpty(endpoint)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key endpoint in key identifier is invalid."));
            }
            if (Strings.isNullOrEmpty(keyName)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key name in key identifier is invalid."));
            }
            if (Strings.isNullOrEmpty(version)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key version in key identifier is invalid."));
            }
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The key identifier is malformed.", e));
        }
    }

    private boolean checkKeyPermissions(List<KeyOperation> operations, KeyOperation keyOperation) {
        return operations.contains((Object)keyOperation);
    }

    private Mono<Boolean> ensureValidKeyAvailable() {
        boolean keyNotAvailable;
        boolean bl = keyNotAvailable = this.key == null && this.keyCollection != null;
        if (keyNotAvailable) {
            if (this.keyCollection.equals(SECRETS_COLLECTION)) {
                return this.getSecretKey().map(jsonWebKey -> {
                    this.key = jsonWebKey;
                    if (this.key.isValid()) {
                        this.initializeCryptoClients();
                        return true;
                    }
                    return false;
                });
            }
            return this.getKey().map(keyVaultKey -> {
                this.key = keyVaultKey.getKey();
                if (this.key.isValid()) {
                    this.initializeCryptoClients();
                    return true;
                }
                return false;
            });
        }
        return Mono.defer(() -> Mono.just((Object)true));
    }

    CryptographyServiceClient getCryptographyServiceClient() {
        return this.cryptographyServiceClient;
    }

    void setCryptographyServiceClient(CryptographyServiceClient serviceClient) {
        this.cryptographyServiceClient = serviceClient;
    }
}

