/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

class KeyRequestAttributes {
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="nbf")
    private Long notBefore;
    @JsonProperty(value="exp")
    private Long expires;
    @JsonProperty(value="created", access=JsonProperty.Access.WRITE_ONLY)
    private Long created;
    @JsonProperty(value="updated", access=JsonProperty.Access.WRITE_ONLY)
    private Long updated;

    KeyRequestAttributes(KeyProperties keyProperties) {
        if (keyProperties.getNotBefore() != null) {
            this.notBefore = keyProperties.getNotBefore().toEpochSecond();
        }
        if (keyProperties.getExpiresOn() != null) {
            this.expires = keyProperties.getExpiresOn().toEpochSecond();
        }
        this.enabled = keyProperties.isEnabled();
    }

    KeyRequestAttributes(CreateKeyOptions keyOptions) {
        if (keyOptions.getNotBefore() != null) {
            this.notBefore = keyOptions.getNotBefore().toEpochSecond();
        }
        if (keyOptions.getExpiresOn() != null) {
            this.expires = keyOptions.getExpiresOn().toEpochSecond();
        }
        this.enabled = keyOptions.isEnabled();
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public KeyRequestAttributes setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.notBefore * 1000L), ZoneOffset.UTC);
    }

    public KeyRequestAttributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(OffsetDateTime.ofInstant(notBefore.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.expires * 1000L), ZoneOffset.UTC);
    }

    public KeyRequestAttributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(OffsetDateTime.ofInstant(expires.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.created * 1000L), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.updated * 1000L), ZoneOffset.UTC);
    }
}

