/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.KeyVaultCertificateWithPolicyHelper;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import java.io.IOException;
import java.util.Map;

public class KeyVaultCertificateWithPolicy
extends KeyVaultCertificate {
    private CertificatePolicy policy;

    KeyVaultCertificateWithPolicy() {
    }

    KeyVaultCertificateWithPolicy(CertificateBundle bundle) {
        this(bundle.getCer(), bundle.getKid(), bundle.getSid(), new CertificateProperties(bundle), CertificatePolicyHelper.createCertificatePolicy(bundle.getPolicy()));
    }

    KeyVaultCertificateWithPolicy(byte[] cer, String kid, String sid, CertificateProperties properties) {
        this(cer, kid, sid, properties, null);
    }

    KeyVaultCertificateWithPolicy(byte[] cer, String kid, String sid, CertificateProperties properties, CertificatePolicy policy) {
        super(cer, kid, sid, properties);
        this.policy = policy;
    }

    @Override
    public KeyVaultCertificateWithPolicy setProperties(CertificateProperties properties) {
        super.setProperties(properties);
        return this;
    }

    public CertificatePolicy getPolicy() {
        return this.policy;
    }

    public KeyVaultCertificateWithPolicy setPolicy(CertificatePolicy certificatePolicy) {
        this.policy = certificatePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeBinaryField("cer", this.getCer()).writeJsonField("policy", (JsonSerializable)this.policy).writeEndObject();
    }

    public static KeyVaultCertificateWithPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultCertificateWithPolicy)jsonReader.readObject(reader -> {
            String id = null;
            CertificateAttributes attributes = null;
            Map tags = null;
            byte[] wireThumbprint = null;
            byte[] cer = null;
            String keyId = null;
            String secretId = null;
            CertificatePolicy policy = null;
            boolean certificateOrderPreserved = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    wireThumbprint = reader.getBinary();
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    cer = reader.getBinary();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    keyId = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    secretId = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    policy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    certificateOrderPreserved = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyVaultCertificateWithPolicy(cer, keyId, secretId, new CertificateProperties(id, attributes, tags, wireThumbprint, null, certificateOrderPreserved), policy);
        });
    }

    static {
        KeyVaultCertificateWithPolicyHelper.setAccessor(KeyVaultCertificateWithPolicy::new);
    }
}

