/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.CertificatePolicyHelper;
import com.azure.security.keyvault.certificates.implementation.DeletedCertificateHelper;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.DeletedCertificateItem;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedCertificate
extends KeyVaultCertificateWithPolicy {
    private final String recoveryId;
    private final OffsetDateTime scheduledPurgeDate;
    private final OffsetDateTime deletedOn;

    public DeletedCertificate() {
        this.recoveryId = null;
        this.deletedOn = null;
        this.scheduledPurgeDate = null;
    }

    private DeletedCertificate(DeletedCertificateItem item) {
        this(null, null, null, new CertificateProperties(item), null, item.getRecoveryId(), item.getDeletedDate(), item.getScheduledPurgeDate());
    }

    private DeletedCertificate(DeletedCertificateBundle bundle) {
        this(bundle.getCer(), bundle.getKid(), bundle.getSid(), new CertificateProperties(bundle), CertificatePolicyHelper.createCertificatePolicy(bundle.getPolicy()), bundle.getRecoveryId(), bundle.getDeletedDate(), bundle.getScheduledPurgeDate());
    }

    private DeletedCertificate(byte[] cer, String kid, String sid, CertificateProperties properties, CertificatePolicy policy, String recoveryId, OffsetDateTime deletedOn, OffsetDateTime scheduledPurgeDate) {
        super(cer, kid, sid, properties, policy);
        this.recoveryId = recoveryId;
        this.deletedOn = deletedOn;
        this.scheduledPurgeDate = scheduledPurgeDate;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeBinaryField("cer", this.getCer()).writeJsonField("policy", (JsonSerializable)this.getPolicy()).writeStringField("recoverId", this.recoveryId).writeEndObject();
    }

    public static DeletedCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedCertificate)jsonReader.readObject(reader -> {
            String id = null;
            CertificateAttributes attributes = null;
            Map tags = null;
            byte[] wireThumbprint = null;
            byte[] cer = null;
            String keyId = null;
            String secretId = null;
            CertificatePolicy policy = null;
            String recoveryId = null;
            OffsetDateTime deletedOn = null;
            OffsetDateTime scheduledPurgeDate = null;
            boolean certificateOrderPreserved = false;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    attributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    wireThumbprint = reader.getBinary();
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    cer = reader.getBinary();
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    keyId = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    secretId = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    policy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    recoveryId = reader.getString();
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deletedOn = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(nonNull.getLong() * 1000L), ZoneOffset.UTC));
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    scheduledPurgeDate = (OffsetDateTime)reader.getNullable(nonNull -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(nonNull.getLong() * 1000L), ZoneOffset.UTC));
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    certificateOrderPreserved = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return new DeletedCertificate(cer, keyId, secretId, new CertificateProperties(id, attributes, tags, wireThumbprint, null, certificateOrderPreserved), policy, recoveryId, deletedOn, scheduledPurgeDate);
        });
    }

    static {
        DeletedCertificateHelper.setAccessor(new DeletedCertificateHelper.DeletedCertificateAccessor(){

            @Override
            public DeletedCertificate createDeletedCertificate(DeletedCertificateItem item) {
                return new DeletedCertificate(item);
            }

            @Override
            public DeletedCertificate createDeletedCertificate(DeletedCertificateBundle bundle) {
                return new DeletedCertificate(bundle);
            }
        });
    }
}

