/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class IssuerAttributes
implements JsonSerializable<IssuerAttributes> {
    private Boolean enabled;
    private Long created;
    private Long updated;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public IssuerAttributes setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static IssuerAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (IssuerAttributes)jsonReader.readObject(reader -> {
            IssuerAttributes deserializedIssuerAttributes = new IssuerAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedIssuerAttributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedIssuerAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedIssuerAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIssuerAttributes;
        });
    }
}

