/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CertificateMergeParameters
implements JsonSerializable<CertificateMergeParameters> {
    private final List<byte[]> x509Certificates;
    private CertificateAttributes certificateAttributes;
    private Map<String, String> tags;

    public CertificateMergeParameters(List<byte[]> x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public List<byte[]> getX509Certificates() {
        return this.x509Certificates;
    }

    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public CertificateMergeParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public CertificateMergeParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("x5c", this.x509Certificates, (writer, element) -> writer.writeBinary(element));
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CertificateMergeParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateMergeParameters)jsonReader.readObject(reader -> {
            List x509Certificates = null;
            CertificateAttributes certificateAttributes = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x5c".equals(fieldName)) {
                    x509Certificates = reader.readArray(reader1 -> reader1.getBinary());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    certificateAttributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CertificateMergeParameters deserializedCertificateMergeParameters = new CertificateMergeParameters(x509Certificates);
            deserializedCertificateMergeParameters.certificateAttributes = certificateAttributes;
            deserializedCertificateMergeParameters.tags = tags;
            return deserializedCertificateMergeParameters;
        });
    }
}

