/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.util.Map;

public final class CertificateCreateParameters
implements JsonSerializable<CertificateCreateParameters> {
    private CertificatePolicy certificatePolicy;
    private CertificateAttributes certificateAttributes;
    private Map<String, String> tags;
    private Boolean preserveCertOrder;

    public CertificatePolicy getCertificatePolicy() {
        return this.certificatePolicy;
    }

    public CertificateCreateParameters setCertificatePolicy(CertificatePolicy certificatePolicy) {
        this.certificatePolicy = certificatePolicy;
        return this;
    }

    public CertificateAttributes getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public CertificateCreateParameters setCertificateAttributes(CertificateAttributes certificateAttributes) {
        this.certificateAttributes = certificateAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public CertificateCreateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isPreserveCertOrder() {
        return this.preserveCertOrder;
    }

    public CertificateCreateParameters setPreserveCertOrder(Boolean preserveCertOrder) {
        this.preserveCertOrder = preserveCertOrder;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.certificatePolicy);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.certificateAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveCertOrder", this.preserveCertOrder);
        return jsonWriter.writeEndObject();
    }

    public static CertificateCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCreateParameters)jsonReader.readObject(reader -> {
            CertificateCreateParameters deserializedCertificateCreateParameters = new CertificateCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedCertificateCreateParameters.certificatePolicy = CertificatePolicy.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedCertificateCreateParameters.certificateAttributes = CertificateAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCertificateCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("preserveCertOrder".equals(fieldName)) {
                    deserializedCertificateCreateParameters.preserveCertOrder = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCreateParameters;
        });
    }
}

