/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.certificates.CertificateServiceVersion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class CertificateClientImpl {
    private final CertificateClientService service;
    private final String vaultBaseUrl;
    private final CertificateServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getVaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public CertificateServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public CertificateClientImpl(String vaultBaseUrl, CertificateServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    public CertificateClientImpl(HttpPipeline httpPipeline, String vaultBaseUrl, CertificateServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), vaultBaseUrl, serviceVersion);
    }

    public CertificateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String vaultBaseUrl, CertificateServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.vaultBaseUrl = vaultBaseUrl;
        this.serviceVersion = serviceVersion;
        this.service = (CertificateClientService)RestProxy.create(CertificateClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificatesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificates(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.getCertificatesSinglePageAsync(requestOptions), nextLink -> this.getCertificatesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificatesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificatesSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificates(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.getCertificatesSinglePage(requestOptions), nextLink -> this.getCertificatesNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> setCertificateContactsWithResponseAsync(BinaryData contacts, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setCertificateContacts(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", contacts, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> setCertificateContactsWithResponse(BinaryData contacts, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.setCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", contacts, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateContactsWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateContacts(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateContactsWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateContactsWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateContacts(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateContactsWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteCertificateContactsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateIssuersSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuers(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificateIssuersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.getCertificateIssuersSinglePageAsync(requestOptions), nextLink -> this.getCertificateIssuersNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateIssuersSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificateIssuersSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificateIssuers(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.getCertificateIssuersSinglePage(requestOptions), nextLink -> this.getCertificateIssuersNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> setCertificateIssuerWithResponseAsync(String issuerName, BinaryData parameter, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", "application/json", parameter, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> setCertificateIssuerWithResponse(String issuerName, BinaryData parameter, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.setCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", "application/json", parameter, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateIssuerWithResponseAsync(String issuerName, BinaryData parameter, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", "application/json", parameter, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateIssuerWithResponse(String issuerName, BinaryData parameter, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", "application/json", parameter, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateIssuerWithResponseAsync(String issuerName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateIssuerWithResponse(String issuerName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateIssuerWithResponseAsync(String issuerName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateIssuer(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateIssuerWithResponse(String issuerName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteCertificateIssuerSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), issuerName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createCertificateWithResponseAsync(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createCertificateWithResponse(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> importCertificateWithResponseAsync(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.importCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> importCertificateWithResponse(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.importCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateVersionsSinglePageAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateVersions(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getCertificateVersionsAsync(String certificateName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.getCertificateVersionsSinglePageAsync(certificateName, requestOptions), nextLink -> this.getCertificateVersionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateVersionsSinglePage(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificateVersionsSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getCertificateVersions(String certificateName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.getCertificateVersionsSinglePage(certificateName, requestOptions), nextLink -> this.getCertificateVersionsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificatePolicyWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificatePolicy(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificatePolicyWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificatePolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificatePolicyWithResponseAsync(String certificateName, BinaryData certificatePolicy, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificatePolicy(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", certificatePolicy, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateCertificatePolicyWithResponse(String certificateName, BinaryData certificatePolicy, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateCertificatePolicySync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", certificatePolicy, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateWithResponseAsync(String certificateName, String certificateVersion, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, certificateVersion, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateWithResponse(String certificateName, String certificateVersion, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, certificateVersion, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateWithResponseAsync(String certificateName, String certificateVersion, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, certificateVersion, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateWithResponse(String certificateName, String certificateVersion, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, certificateVersion, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCertificateOperationWithResponseAsync(String certificateName, BinaryData certificateOperation, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificateOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", certificateOperation, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateCertificateOperationWithResponse(String certificateName, BinaryData certificateOperation, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", certificateOperation, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateOperationWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCertificateOperationWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteCertificateOperationWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificateOperation(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteCertificateOperationWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteCertificateOperationSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> mergeCertificateWithResponseAsync(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.mergeCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> mergeCertificateWithResponse(String certificateName, BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.mergeCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> backupCertificateWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backupCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> backupCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.backupCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> restoreCertificateWithResponseAsync(BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", parameters, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> restoreCertificateWithResponse(BinaryData parameters, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.restoreCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", "application/json", parameters, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedCertificatesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificates(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> getDeletedCertificatesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.getDeletedCertificatesSinglePageAsync(requestOptions), nextLink -> this.getDeletedCertificatesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedCertificatesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getDeletedCertificatesSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> getDeletedCertificates(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.getDeletedCertificatesSinglePage(requestOptions), nextLink -> this.getDeletedCertificatesNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeletedCertificateWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDeletedCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedCertificateWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purgeDeletedCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.purgeDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> recoverDeletedCertificateWithResponseAsync(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recoverDeletedCertificate(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> recoverDeletedCertificateWithResponse(String certificateName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.recoverDeletedCertificateSync(this.getVaultBaseUrl(), this.getServiceVersion().getVersion(), certificateName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificatesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificatesNext(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificatesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificatesNextSync(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateIssuersNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateIssuersNext(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateIssuersNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificateIssuersNextSync(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getCertificateVersionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificateVersionsNext(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getCertificateVersionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getCertificateVersionsNextSync(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> getDeletedCertificatesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedCertificatesNext(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> getDeletedCertificatesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.getDeletedCertificatesNextSync(nextLink, this.getVaultBaseUrl(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="CertificateClient")
    public static interface CertificateClientService {
        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificates(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificatesSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/certificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Put(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> setCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> setCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteCertificateContacts(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/certificates/contacts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteCertificateContactsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/certificates/issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateIssuers(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/certificates/issuers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateIssuersSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> setCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> setCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteCertificateIssuer(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/certificates/issuers/{issuer-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteCertificateIssuerSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="issuer-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/certificates/{certificate-name}/create")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> importCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/certificates/{certificate-name}/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> importCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateVersions(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/certificates/{certificate-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateVersionsSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificatePolicy(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificatePolicySync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateCertificatePolicy(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/certificates/{certificate-name}/policy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateCertificatePolicySync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @PathParam(value="certificate-version") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Patch(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @PathParam(value="certificate-version") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Get(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @PathParam(value="certificate-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/certificates/{certificate-name}/{certificate-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @PathParam(value="certificate-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Patch(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteCertificateOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/certificates/{certificate-name}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteCertificateOperationSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> mergeCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/certificates/{certificate-name}/pending/merge")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> mergeCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> backupCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/certificates/{certificate-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> backupCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> restoreCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/certificates/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> restoreCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getDeletedCertificates(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/deletedcertificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getDeletedCertificatesSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> purgeDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/deletedcertificates/{certificate-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> purgeDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> recoverDeletedCertificate(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/deletedcertificates/{certificate-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> recoverDeletedCertificateSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="certificate-name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificatesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateIssuersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateIssuersNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getCertificateVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getCertificateVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getDeletedCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getDeletedCertificatesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

