// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AttestationType. */
public final class AttestationType extends ExpandableStringEnum<AttestationType> {
    /** Static value SgxEnclave for AttestationType. */
    public static final AttestationType SGX_ENCLAVE = fromString("SgxEnclave");

    /** Static value OpenEnclave for AttestationType. */
    public static final AttestationType OPEN_ENCLAVE = fromString("OpenEnclave");

    /** Static value Tpm for AttestationType. */
    public static final AttestationType TPM = fromString("Tpm");

    /**
     * Creates or finds a AttestationType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AttestationType.
     */
    @JsonCreator
    public static AttestationType fromString(String name) {
        return fromString(name, AttestationType.class);
    }

    /** @return known AttestationType values. */
    public static Collection<AttestationType> values() {
        return values(AttestationType.class);
    }
}
