// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.ResponseBase;

/**
 * The result of an attestation operation.
 */
@Immutable
public final class AttestationResponse<T> extends ResponseBase<Void, T> {

    /*
     * An RFC 7519 JSON Web Token, the body of which is an AttestationResult
     * object.
     */
    private final AttestationToken token;

    /**
     * Creates a {@link ResponseBase}.
     *
     * @param request The HTTP request which resulted in this response.
     * @param statusCode The status code of the HTTP response.
     * @param headers The headers of the HTTP response.
     * @param value The deserialized value of the HTTP response.
     * @param token The Attestation Token which was returned from the service.
     */
    public AttestationResponse(HttpRequest request, int statusCode, HttpHeaders headers, T value, AttestationToken token) {
        super(request, statusCode, headers, value, null);
        this.token = token;
    }

    /**
     * Get the token property: An RFC 7519 JSON Web Token, the body of which is an AttestationResult object.
     *
     * @return the token value.
     */
    public AttestationToken getToken() {
        return this.token;
    }
}
