// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The StoredAttestationPolicy model. */
@Fluent
public final class StoredAttestationPolicy {
    /*
     * Policy text to set as a sequence of UTF-8 encoded octets.
     */
    @JsonProperty(value = "AttestationPolicy")
    private Base64Url attestationPolicy;

    /**
     * Get the attestationPolicy property: Policy text to set as a sequence of UTF-8 encoded octets.
     *
     * @return the attestationPolicy value.
     */
    public byte[] getAttestationPolicy() {
        if (this.attestationPolicy == null) {
            return new byte[0];
        }
        return this.attestationPolicy.decodedBytes();
    }

    /**
     * Set the attestationPolicy property: Policy text to set as a sequence of UTF-8 encoded octets.
     *
     * @param attestationPolicy the attestationPolicy value to set.
     * @return the StoredAttestationPolicy object itself.
     */
    public StoredAttestationPolicy setAttestationPolicy(byte[] attestationPolicy) {
        if (attestationPolicy == null) {
            this.attestationPolicy = null;
        } else {
            this.attestationPolicy = Base64Url.encode(CoreUtils.clone(attestationPolicy));
        }
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
