// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The response to an attestation policy operation. */
@Fluent
public final class PolicyResponse {
    /*
     * An RFC7519 JSON Web Token structure whose body is an PolicyResult
     * object.
     */
    @JsonProperty(value = "token")
    private String token;

    /**
     * Get the token property: An RFC7519 JSON Web Token structure whose body is an PolicyResult object.
     *
     * @return the token value.
     */
    public String getToken() {
        return this.token;
    }

    /**
     * Set the token property: An RFC7519 JSON Web Token structure whose body is an PolicyResult object.
     *
     * @param token the token value to set.
     * @return the PolicyResponse object itself.
     */
    public PolicyResponse setToken(String token) {
        this.token = token;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
