// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The JsonWebKeySet model. */
@Fluent
public final class JsonWebKeySet {
    /*
     * The value of the "keys" parameter is an array of JWK values.  By
     * default, the order of the JWK values within the array does not imply
     * an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if
     * desired.
     */
    @JsonProperty(value = "keys")
    private List<JsonWebKey> keys;

    /**
     * Get the keys property: The value of the "keys" parameter is an array of JWK values. By default, the order of the
     * JWK values within the array does not imply an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if desired.
     *
     * @return the keys value.
     */
    public List<JsonWebKey> getKeys() {
        return this.keys;
    }

    /**
     * Set the keys property: The value of the "keys" parameter is an array of JWK values. By default, the order of the
     * JWK values within the array does not imply an order of preference among them, although applications of JWK Sets
     * can choose to assign a meaning to the order for their purposes, if desired.
     *
     * @param keys the keys value to set.
     * @return the JsonWebKeySet object itself.
     */
    public JsonWebKeySet setKeys(List<JsonWebKey> keys) {
        this.keys = keys;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getKeys() != null) {
            getKeys().forEach(e -> e.validate());
        }
    }
}
