// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An error response from Attestation. */
@Fluent
public final class CloudError {
    /*
     * An error response from Attestation.
     */
    @JsonProperty(value = "error")
    private CloudErrorBody error;

    /**
     * Get the error property: An error response from Attestation.
     *
     * @return the error value.
     */
    public CloudErrorBody getError() {
        return this.error;
    }

    /**
     * Set the error property: An error response from Attestation.
     *
     * @param error the error value to set.
     * @return the CloudError object itself.
     */
    public CloudError setError(CloudErrorBody error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getError() != null) {
            getError().validate();
        }
    }
}
