// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A Microsoft Azure Attestation response token body - the body of a response token issued by MAA. */
@Fluent
public final class AttestationResult {
    /*
     * Unique Identifier for the token
     */
    @JsonProperty(value = "jti")
    private String jti;

    /*
     * The Principal who issued the token
     */
    @JsonProperty(value = "iss")
    private String iss;

    /*
     * The time at which the token was issued, in the number of seconds since
     * 1970-01-0T00:00:00Z UTC
     */
    @JsonProperty(value = "iat")
    private Float iat;

    /*
     * The expiration time after which the token is no longer valid, in the
     * number of seconds since 1970-01-0T00:00:00Z UTC
     */
    @JsonProperty(value = "exp")
    private Float exp;

    /*
     * The not before time before which the token cannot be considered valid,
     * in the number of seconds since 1970-01-0T00:00:00Z UTC
     */
    @JsonProperty(value = "nbf")
    private Float nbf;

    /*
     * An RFC 7800 Proof of Possession Key
     */
    @JsonProperty(value = "cnf")
    private Object cnf;

    /*
     * The Nonce input to the attestation request, if provided.
     */
    @JsonProperty(value = "nonce")
    private String nonce;

    /*
     * The Schema version of this structure. Current Value: 1.0
     */
    @JsonProperty(value = "x-ms-ver")
    private String version;

    /*
     * Runtime Claims
     */
    @JsonProperty(value = "x-ms-runtime")
    private Object runtimeClaims;

    /*
     * Inittime Claims
     */
    @JsonProperty(value = "x-ms-inittime")
    private Object inittimeClaims;

    /*
     * Policy Generated Claims
     */
    @JsonProperty(value = "x-ms-policy")
    private Object policyClaims;

    /*
     * The Attestation type being attested.
     */
    @JsonProperty(value = "x-ms-attestation-type")
    private String verifierType;

    /*
     * The certificate used to sign the policy object, if specified.
     */
    @JsonProperty(value = "x-ms-policy-signer")
    private JsonWebKey policySigner;

    /*
     * The SHA256 hash of the BASE64URL encoded policy text used for
     * attestation
     */
    @JsonProperty(value = "x-ms-policy-hash")
    private Base64Url policyHash;

    /*
     * True if the enclave is debuggable, false otherwise
     */
    @JsonProperty(value = "x-ms-sgx-is-debuggable")
    private Boolean isDebuggable;

    /*
     * The SGX Product ID for the enclave.
     */
    @JsonProperty(value = "x-ms-sgx-product-id")
    private Float productId;

    /*
     * The HEX encoded SGX MRENCLAVE value for the enclave.
     */
    @JsonProperty(value = "x-ms-sgx-mrenclave")
    private String mrEnclave;

    /*
     * The HEX encoded SGX MRSIGNER value for the enclave.
     */
    @JsonProperty(value = "x-ms-sgx-mrsigner")
    private String mrSigner;

    /*
     * The SGX SVN value for the enclave.
     */
    @JsonProperty(value = "x-ms-sgx-svn")
    private Float svn;

    /*
     * A copy of the RuntimeData specified as an input to the attest call.
     */
    @JsonProperty(value = "x-ms-sgx-ehd")
    private Base64Url enclaveHeldData;

    /*
     * The SGX SVN value for the enclave.
     */
    @JsonProperty(value = "x-ms-sgx-collateral")
    private Object sgxCollateral;

    /*
     * DEPRECATED: Private Preview version of x-ms-ver claim.
     */
    @JsonProperty(value = "ver")
    private String deprecatedVersion;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable claim.
     */
    @JsonProperty(value = "is-debuggable")
    private Boolean deprecatedIsDebuggable;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-collateral claim.
     */
    @JsonProperty(value = "maa-attestationcollateral")
    private Object deprecatedSgxCollateral;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     */
    @JsonProperty(value = "aas-ehd")
    private Base64Url deprecatedEnclaveHeldData;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     */
    @JsonProperty(value = "maa-ehd")
    private Base64Url deprecatedEnclaveHeldData2;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-product-id
     */
    @JsonProperty(value = "product-id")
    private Float deprecatedProductId;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
     */
    @JsonProperty(value = "sgx-mrenclave")
    private String deprecatedMrEnclave;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
     */
    @JsonProperty(value = "sgx-mrsigner")
    private String deprecatedMrSigner;

    /*
     * DEPRECATED: Private Preview version of x-ms-sgx-svn.
     */
    @JsonProperty(value = "svn")
    private Float deprecatedSvn;

    /*
     * DEPRECATED: Private Preview version of x-ms-tee.
     */
    @JsonProperty(value = "tee")
    private String deprecatedTee;

    /*
     * DEPRECATED: Private Preview version of x-ms-policy-signer
     */
    @JsonProperty(value = "policy_signer")
    private JsonWebKey deprecatedPolicySigner;

    /*
     * DEPRECATED: Private Preview version of x-ms-policy-hash
     */
    @JsonProperty(value = "policy_hash")
    private Base64Url deprecatedPolicyHash;

    /*
     * DEPRECATED: Private Preview version of nonce
     */
    @JsonProperty(value = "rp_data")
    private String deprecatedRpData;

    /**
     * Get the jti property: Unique Identifier for the token.
     *
     * @return the jti value.
     */
    public String getJti() {
        return this.jti;
    }

    /**
     * Set the jti property: Unique Identifier for the token.
     *
     * @param jti the jti value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setJti(String jti) {
        this.jti = jti;
        return this;
    }

    /**
     * Get the iss property: The Principal who issued the token.
     *
     * @return the iss value.
     */
    public String getIss() {
        return this.iss;
    }

    /**
     * Set the iss property: The Principal who issued the token.
     *
     * @param iss the iss value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setIss(String iss) {
        this.iss = iss;
        return this;
    }

    /**
     * Get the iat property: The time at which the token was issued, in the number of seconds since 1970-01-0T00:00:00Z
     * UTC.
     *
     * @return the iat value.
     */
    public Float getIat() {
        return this.iat;
    }

    /**
     * Set the iat property: The time at which the token was issued, in the number of seconds since 1970-01-0T00:00:00Z
     * UTC.
     *
     * @param iat the iat value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setIat(Float iat) {
        this.iat = iat;
        return this;
    }

    /**
     * Get the exp property: The expiration time after which the token is no longer valid, in the number of seconds
     * since 1970-01-0T00:00:00Z UTC.
     *
     * @return the exp value.
     */
    public Float getExp() {
        return this.exp;
    }

    /**
     * Set the exp property: The expiration time after which the token is no longer valid, in the number of seconds
     * since 1970-01-0T00:00:00Z UTC.
     *
     * @param exp the exp value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setExp(Float exp) {
        this.exp = exp;
        return this;
    }

    /**
     * Get the nbf property: The not before time before which the token cannot be considered valid, in the number of
     * seconds since 1970-01-0T00:00:00Z UTC.
     *
     * @return the nbf value.
     */
    public Float getNbf() {
        return this.nbf;
    }

    /**
     * Set the nbf property: The not before time before which the token cannot be considered valid, in the number of
     * seconds since 1970-01-0T00:00:00Z UTC.
     *
     * @param nbf the nbf value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setNbf(Float nbf) {
        this.nbf = nbf;
        return this;
    }

    /**
     * Get the cnf property: An RFC 7800 Proof of Possession Key.
     *
     * @return the cnf value.
     */
    public Object getCnf() {
        return this.cnf;
    }

    /**
     * Set the cnf property: An RFC 7800 Proof of Possession Key.
     *
     * @param cnf the cnf value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setCnf(Object cnf) {
        this.cnf = cnf;
        return this;
    }

    /**
     * Get the nonce property: The Nonce input to the attestation request, if provided.
     *
     * @return the nonce value.
     */
    public String getNonce() {
        return this.nonce;
    }

    /**
     * Set the nonce property: The Nonce input to the attestation request, if provided.
     *
     * @param nonce the nonce value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    /**
     * Get the version property: The Schema version of this structure. Current Value: 1.0.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The Schema version of this structure. Current Value: 1.0.
     *
     * @param version the version value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the runtimeClaims property: Runtime Claims.
     *
     * @return the runtimeClaims value.
     */
    public Object getRuntimeClaims() {
        return this.runtimeClaims;
    }

    /**
     * Set the runtimeClaims property: Runtime Claims.
     *
     * @param runtimeClaims the runtimeClaims value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setRuntimeClaims(Object runtimeClaims) {
        this.runtimeClaims = runtimeClaims;
        return this;
    }

    /**
     * Get the inittimeClaims property: Inittime Claims.
     *
     * @return the inittimeClaims value.
     */
    public Object getInittimeClaims() {
        return this.inittimeClaims;
    }

    /**
     * Set the inittimeClaims property: Inittime Claims.
     *
     * @param inittimeClaims the inittimeClaims value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setInittimeClaims(Object inittimeClaims) {
        this.inittimeClaims = inittimeClaims;
        return this;
    }

    /**
     * Get the policyClaims property: Policy Generated Claims.
     *
     * @return the policyClaims value.
     */
    public Object getPolicyClaims() {
        return this.policyClaims;
    }

    /**
     * Set the policyClaims property: Policy Generated Claims.
     *
     * @param policyClaims the policyClaims value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setPolicyClaims(Object policyClaims) {
        this.policyClaims = policyClaims;
        return this;
    }

    /**
     * Get the verifierType property: The Attestation type being attested.
     *
     * @return the verifierType value.
     */
    public String getVerifierType() {
        return this.verifierType;
    }

    /**
     * Set the verifierType property: The Attestation type being attested.
     *
     * @param verifierType the verifierType value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setVerifierType(String verifierType) {
        this.verifierType = verifierType;
        return this;
    }

    /**
     * Get the policySigner property: The certificate used to sign the policy object, if specified.
     *
     * @return the policySigner value.
     */
    public JsonWebKey getPolicySigner() {
        return this.policySigner;
    }

    /**
     * Set the policySigner property: The certificate used to sign the policy object, if specified.
     *
     * @param policySigner the policySigner value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setPolicySigner(JsonWebKey policySigner) {
        this.policySigner = policySigner;
        return this;
    }

    /**
     * Get the policyHash property: The SHA256 hash of the BASE64URL encoded policy text used for attestation.
     *
     * @return the policyHash value.
     */
    public byte[] getPolicyHash() {
        if (this.policyHash == null) {
            return new byte[0];
        }
        return this.policyHash.decodedBytes();
    }

    /**
     * Set the policyHash property: The SHA256 hash of the BASE64URL encoded policy text used for attestation.
     *
     * @param policyHash the policyHash value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setPolicyHash(byte[] policyHash) {
        if (policyHash == null) {
            this.policyHash = null;
        } else {
            this.policyHash = Base64Url.encode(CoreUtils.clone(policyHash));
        }
        return this;
    }

    /**
     * Get the isDebuggable property: True if the enclave is debuggable, false otherwise.
     *
     * @return the isDebuggable value.
     */
    public Boolean isDebuggable() {
        return this.isDebuggable;
    }

    /**
     * Set the isDebuggable property: True if the enclave is debuggable, false otherwise.
     *
     * @param isDebuggable the isDebuggable value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setIsDebuggable(Boolean isDebuggable) {
        this.isDebuggable = isDebuggable;
        return this;
    }

    /**
     * Get the productId property: The SGX Product ID for the enclave.
     *
     * @return the productId value.
     */
    public Float getProductId() {
        return this.productId;
    }

    /**
     * Set the productId property: The SGX Product ID for the enclave.
     *
     * @param productId the productId value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setProductId(Float productId) {
        this.productId = productId;
        return this;
    }

    /**
     * Get the mrEnclave property: The HEX encoded SGX MRENCLAVE value for the enclave.
     *
     * @return the mrEnclave value.
     */
    public String getMrEnclave() {
        return this.mrEnclave;
    }

    /**
     * Set the mrEnclave property: The HEX encoded SGX MRENCLAVE value for the enclave.
     *
     * @param mrEnclave the mrEnclave value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setMrEnclave(String mrEnclave) {
        this.mrEnclave = mrEnclave;
        return this;
    }

    /**
     * Get the mrSigner property: The HEX encoded SGX MRSIGNER value for the enclave.
     *
     * @return the mrSigner value.
     */
    public String getMrSigner() {
        return this.mrSigner;
    }

    /**
     * Set the mrSigner property: The HEX encoded SGX MRSIGNER value for the enclave.
     *
     * @param mrSigner the mrSigner value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setMrSigner(String mrSigner) {
        this.mrSigner = mrSigner;
        return this;
    }

    /**
     * Get the svn property: The SGX SVN value for the enclave.
     *
     * @return the svn value.
     */
    public Float getSvn() {
        return this.svn;
    }

    /**
     * Set the svn property: The SGX SVN value for the enclave.
     *
     * @param svn the svn value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setSvn(Float svn) {
        this.svn = svn;
        return this;
    }

    /**
     * Get the enclaveHeldData property: A copy of the RuntimeData specified as an input to the attest call.
     *
     * @return the enclaveHeldData value.
     */
    public byte[] getEnclaveHeldData() {
        if (this.enclaveHeldData == null) {
            return new byte[0];
        }
        return this.enclaveHeldData.decodedBytes();
    }

    /**
     * Set the enclaveHeldData property: A copy of the RuntimeData specified as an input to the attest call.
     *
     * @param enclaveHeldData the enclaveHeldData value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setEnclaveHeldData(byte[] enclaveHeldData) {
        if (enclaveHeldData == null) {
            this.enclaveHeldData = null;
        } else {
            this.enclaveHeldData = Base64Url.encode(CoreUtils.clone(enclaveHeldData));
        }
        return this;
    }

    /**
     * Get the sgxCollateral property: The SGX SVN value for the enclave.
     *
     * @return the sgxCollateral value.
     */
    public Object getSgxCollateral() {
        return this.sgxCollateral;
    }

    /**
     * Set the sgxCollateral property: The SGX SVN value for the enclave.
     *
     * @param sgxCollateral the sgxCollateral value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setSgxCollateral(Object sgxCollateral) {
        this.sgxCollateral = sgxCollateral;
        return this;
    }

    /**
     * Get the deprecatedVersion property: DEPRECATED: Private Preview version of x-ms-ver claim.
     *
     * @return the deprecatedVersion value.
     */
    public String getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    /**
     * Set the deprecatedVersion property: DEPRECATED: Private Preview version of x-ms-ver claim.
     *
     * @param deprecatedVersion the deprecatedVersion value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedVersion(String deprecatedVersion) {
        this.deprecatedVersion = deprecatedVersion;
        return this;
    }

    /**
     * Get the deprecatedIsDebuggable property: DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable claim.
     *
     * @return the deprecatedIsDebuggable value.
     */
    public Boolean isDeprecatedIsDebuggable() {
        return this.deprecatedIsDebuggable;
    }

    /**
     * Set the deprecatedIsDebuggable property: DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable claim.
     *
     * @param deprecatedIsDebuggable the deprecatedIsDebuggable value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedIsDebuggable(Boolean deprecatedIsDebuggable) {
        this.deprecatedIsDebuggable = deprecatedIsDebuggable;
        return this;
    }

    /**
     * Get the deprecatedSgxCollateral property: DEPRECATED: Private Preview version of x-ms-sgx-collateral claim.
     *
     * @return the deprecatedSgxCollateral value.
     */
    public Object getDeprecatedSgxCollateral() {
        return this.deprecatedSgxCollateral;
    }

    /**
     * Set the deprecatedSgxCollateral property: DEPRECATED: Private Preview version of x-ms-sgx-collateral claim.
     *
     * @param deprecatedSgxCollateral the deprecatedSgxCollateral value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedSgxCollateral(Object deprecatedSgxCollateral) {
        this.deprecatedSgxCollateral = deprecatedSgxCollateral;
        return this;
    }

    /**
     * Get the deprecatedEnclaveHeldData property: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     *
     * @return the deprecatedEnclaveHeldData value.
     */
    public byte[] getDeprecatedEnclaveHeldData() {
        if (this.deprecatedEnclaveHeldData == null) {
            return new byte[0];
        }
        return this.deprecatedEnclaveHeldData.decodedBytes();
    }

    /**
     * Set the deprecatedEnclaveHeldData property: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     *
     * @param deprecatedEnclaveHeldData the deprecatedEnclaveHeldData value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedEnclaveHeldData(byte[] deprecatedEnclaveHeldData) {
        if (deprecatedEnclaveHeldData == null) {
            this.deprecatedEnclaveHeldData = null;
        } else {
            this.deprecatedEnclaveHeldData = Base64Url.encode(CoreUtils.clone(deprecatedEnclaveHeldData));
        }
        return this;
    }

    /**
     * Get the deprecatedEnclaveHeldData2 property: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     *
     * @return the deprecatedEnclaveHeldData2 value.
     */
    public byte[] getDeprecatedEnclaveHeldData2() {
        if (this.deprecatedEnclaveHeldData2 == null) {
            return new byte[0];
        }
        return this.deprecatedEnclaveHeldData2.decodedBytes();
    }

    /**
     * Set the deprecatedEnclaveHeldData2 property: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
     *
     * @param deprecatedEnclaveHeldData2 the deprecatedEnclaveHeldData2 value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedEnclaveHeldData2(byte[] deprecatedEnclaveHeldData2) {
        if (deprecatedEnclaveHeldData2 == null) {
            this.deprecatedEnclaveHeldData2 = null;
        } else {
            this.deprecatedEnclaveHeldData2 = Base64Url.encode(CoreUtils.clone(deprecatedEnclaveHeldData2));
        }
        return this;
    }

    /**
     * Get the deprecatedProductId property: DEPRECATED: Private Preview version of x-ms-sgx-product-id.
     *
     * @return the deprecatedProductId value.
     */
    public Float getDeprecatedProductId() {
        return this.deprecatedProductId;
    }

    /**
     * Set the deprecatedProductId property: DEPRECATED: Private Preview version of x-ms-sgx-product-id.
     *
     * @param deprecatedProductId the deprecatedProductId value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedProductId(Float deprecatedProductId) {
        this.deprecatedProductId = deprecatedProductId;
        return this;
    }

    /**
     * Get the deprecatedMrEnclave property: DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
     *
     * @return the deprecatedMrEnclave value.
     */
    public String getDeprecatedMrEnclave() {
        return this.deprecatedMrEnclave;
    }

    /**
     * Set the deprecatedMrEnclave property: DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
     *
     * @param deprecatedMrEnclave the deprecatedMrEnclave value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedMrEnclave(String deprecatedMrEnclave) {
        this.deprecatedMrEnclave = deprecatedMrEnclave;
        return this;
    }

    /**
     * Get the deprecatedMrSigner property: DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
     *
     * @return the deprecatedMrSigner value.
     */
    public String getDeprecatedMrSigner() {
        return this.deprecatedMrSigner;
    }

    /**
     * Set the deprecatedMrSigner property: DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
     *
     * @param deprecatedMrSigner the deprecatedMrSigner value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedMrSigner(String deprecatedMrSigner) {
        this.deprecatedMrSigner = deprecatedMrSigner;
        return this;
    }

    /**
     * Get the deprecatedSvn property: DEPRECATED: Private Preview version of x-ms-sgx-svn.
     *
     * @return the deprecatedSvn value.
     */
    public Float getDeprecatedSvn() {
        return this.deprecatedSvn;
    }

    /**
     * Set the deprecatedSvn property: DEPRECATED: Private Preview version of x-ms-sgx-svn.
     *
     * @param deprecatedSvn the deprecatedSvn value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedSvn(Float deprecatedSvn) {
        this.deprecatedSvn = deprecatedSvn;
        return this;
    }

    /**
     * Get the deprecatedTee property: DEPRECATED: Private Preview version of x-ms-tee.
     *
     * @return the deprecatedTee value.
     */
    public String getDeprecatedTee() {
        return this.deprecatedTee;
    }

    /**
     * Set the deprecatedTee property: DEPRECATED: Private Preview version of x-ms-tee.
     *
     * @param deprecatedTee the deprecatedTee value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedTee(String deprecatedTee) {
        this.deprecatedTee = deprecatedTee;
        return this;
    }

    /**
     * Get the deprecatedPolicySigner property: DEPRECATED: Private Preview version of x-ms-policy-signer.
     *
     * @return the deprecatedPolicySigner value.
     */
    public JsonWebKey getDeprecatedPolicySigner() {
        return this.deprecatedPolicySigner;
    }

    /**
     * Set the deprecatedPolicySigner property: DEPRECATED: Private Preview version of x-ms-policy-signer.
     *
     * @param deprecatedPolicySigner the deprecatedPolicySigner value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedPolicySigner(JsonWebKey deprecatedPolicySigner) {
        this.deprecatedPolicySigner = deprecatedPolicySigner;
        return this;
    }

    /**
     * Get the deprecatedPolicyHash property: DEPRECATED: Private Preview version of x-ms-policy-hash.
     *
     * @return the deprecatedPolicyHash value.
     */
    public byte[] getDeprecatedPolicyHash() {
        if (this.deprecatedPolicyHash == null) {
            return new byte[0];
        }
        return this.deprecatedPolicyHash.decodedBytes();
    }

    /**
     * Set the deprecatedPolicyHash property: DEPRECATED: Private Preview version of x-ms-policy-hash.
     *
     * @param deprecatedPolicyHash the deprecatedPolicyHash value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedPolicyHash(byte[] deprecatedPolicyHash) {
        if (deprecatedPolicyHash == null) {
            this.deprecatedPolicyHash = null;
        } else {
            this.deprecatedPolicyHash = Base64Url.encode(CoreUtils.clone(deprecatedPolicyHash));
        }
        return this;
    }

    /**
     * Get the deprecatedRpData property: DEPRECATED: Private Preview version of nonce.
     *
     * @return the deprecatedRpData value.
     */
    public String getDeprecatedRpData() {
        return this.deprecatedRpData;
    }

    /**
     * Set the deprecatedRpData property: DEPRECATED: Private Preview version of nonce.
     *
     * @param deprecatedRpData the deprecatedRpData value to set.
     * @return the AttestationResult object itself.
     */
    public AttestationResult setDeprecatedRpData(String deprecatedRpData) {
        this.deprecatedRpData = deprecatedRpData;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getPolicySigner() != null) {
            getPolicySigner().validate();
        }
        if (getDeprecatedPolicySigner() != null) {
            getDeprecatedPolicySigner().validate();
        }
    }
}
