// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The body of the JWT used for the PolicyCertificates APIs. */
@Fluent
public final class AttestationCertificateManagementBody {
    /*
     * RFC 7517 Json Web Key describing the certificate.
     */
    @JsonProperty(value = "policyCertificate")
    private JsonWebKey policyCertificate;

    /**
     * Get the policyCertificate property: RFC 7517 Json Web Key describing the certificate.
     *
     * @return the policyCertificate value.
     */
    public JsonWebKey getPolicyCertificate() {
        return this.policyCertificate;
    }

    /**
     * Set the policyCertificate property: RFC 7517 Json Web Key describing the certificate.
     *
     * @param policyCertificate the policyCertificate value to set.
     * @return the AttestationCertificateManagementBody object itself.
     */
    public AttestationCertificateManagementBody setPolicyCertificate(JsonWebKey policyCertificate) {
        this.policyCertificate = policyCertificate;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getPolicyCertificate() != null) {
            getPolicyCertificate().validate();
        }
    }
}
