// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in MetadataConfigurations. */
public final class MetadataConfigurationsImpl {
    /** The proxy service used to perform REST calls. */
    private final MetadataConfigurationsService service;

    /** The service client containing this operation class. */
    private final AttestationClientImpl client;

    /**
     * Initializes an instance of MetadataConfigurationsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    MetadataConfigurationsImpl(AttestationClientImpl client) {
        this.service =
                RestProxy.create(
                        MetadataConfigurationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AttestationClientMetadataConfigurations to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{instanceUrl}")
    @ServiceInterface(name = "AttestationClientMet")
    public interface MetadataConfigurationsService {
        @Get("/.well-known/openid-configuration")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CloudErrorException.class)
        Mono<Response<Object>> get(
                @HostParam("instanceUrl") String instanceUrl, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Retrieves metadata about the attestation signing keys in use by the attestation service.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CloudErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error(
                    new IllegalArgumentException(
                            "Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        final String accept = "application/json";
        return service.get(this.client.getInstanceUrl(), accept, context);
    }
}
