// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.security.attestation.implementation.models.AttestOpenEnclaveRequest;
import com.azure.security.attestation.implementation.models.AttestSgxEnclaveRequest;
import com.azure.security.attestation.implementation.models.AttestationResponse;
import com.azure.security.attestation.implementation.models.CloudErrorException;
import com.azure.security.attestation.implementation.models.TpmAttestationRequest;
import com.azure.security.attestation.implementation.models.TpmAttestationResponse;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Attestations. */
public final class AttestationsImpl {
    /** The proxy service used to perform REST calls. */
    private final AttestationsService service;

    /** The service client containing this operation class. */
    private final AttestationClientImpl client;

    /**
     * Initializes an instance of AttestationsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    AttestationsImpl(AttestationClientImpl client) {
        this.service =
                RestProxy.create(AttestationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AttestationClientAttestations to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{instanceUrl}")
    @ServiceInterface(name = "AttestationClientAtt")
    public interface AttestationsService {
        @Post("/attest/OpenEnclave")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CloudErrorException.class)
        Mono<Response<AttestationResponse>> attestOpenEnclave(
                @HostParam("instanceUrl") String instanceUrl,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AttestOpenEnclaveRequest request,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/attest/SgxEnclave")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CloudErrorException.class)
        Mono<Response<AttestationResponse>> attestSgxEnclave(
                @HostParam("instanceUrl") String instanceUrl,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AttestSgxEnclaveRequest request,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/attest/Tpm")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CloudErrorException.class)
        Mono<Response<TpmAttestationResponse>> attestTpm(
                @HostParam("instanceUrl") String instanceUrl,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") TpmAttestationRequest request,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Processes an OpenEnclave report , producing an artifact. The type of artifact produced is dependent upon
     * attestation policy.
     *
     * @param request Request object containing the quote.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CloudErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of an attestation operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AttestationResponse>> attestOpenEnclaveWithResponseAsync(
            AttestOpenEnclaveRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error(
                    new IllegalArgumentException(
                            "Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return service.attestOpenEnclave(
                this.client.getInstanceUrl(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Processes an SGX enclave quote, producing an artifact. The type of artifact produced is dependent upon
     * attestation policy.
     *
     * @param request Request object containing the quote.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CloudErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of an attestation operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AttestationResponse>> attestSgxEnclaveWithResponseAsync(
            AttestSgxEnclaveRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error(
                    new IllegalArgumentException(
                            "Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return service.attestSgxEnclave(
                this.client.getInstanceUrl(), this.client.getApiVersion(), request, accept, context);
    }

    /**
     * Processes attestation evidence from a VBS enclave, producing an attestation result. The attestation result
     * produced is dependent upon the attestation policy.
     *
     * @param request Request object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CloudErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return attestation response for Trusted Platform Module (TPM) attestation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TpmAttestationResponse>> attestTpmWithResponseAsync(
            TpmAttestationRequest request, Context context) {
        if (this.client.getInstanceUrl() == null) {
            return Mono.error(
                    new IllegalArgumentException(
                            "Parameter this.client.getInstanceUrl() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error(new IllegalArgumentException("Parameter request is required and cannot be null."));
        } else {
            request.validate();
        }
        final String accept = "application/json";
        return service.attestTpm(this.client.getInstanceUrl(), this.client.getApiVersion(), request, accept, context);
    }
}
