// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.attestation.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

/** Initializes a new instance of the AttestationClient type. */
public final class AttestationClientImpl {
    /** The attestation instance base URI, for example https://mytenant.attest.azure.net. */
    private final String instanceUrl;

    /**
     * Gets The attestation instance base URI, for example https://mytenant.attest.azure.net.
     *
     * @return the instanceUrl value.
     */
    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The PoliciesImpl object to access its operations. */
    private final PoliciesImpl policies;

    /**
     * Gets the PoliciesImpl object to access its operations.
     *
     * @return the PoliciesImpl object.
     */
    public PoliciesImpl getPolicies() {
        return this.policies;
    }

    /** The PolicyCertificatesImpl object to access its operations. */
    private final PolicyCertificatesImpl policyCertificates;

    /**
     * Gets the PolicyCertificatesImpl object to access its operations.
     *
     * @return the PolicyCertificatesImpl object.
     */
    public PolicyCertificatesImpl getPolicyCertificates() {
        return this.policyCertificates;
    }

    /** The AttestationsImpl object to access its operations. */
    private final AttestationsImpl attestations;

    /**
     * Gets the AttestationsImpl object to access its operations.
     *
     * @return the AttestationsImpl object.
     */
    public AttestationsImpl getAttestations() {
        return this.attestations;
    }

    /** The SigningCertificatesImpl object to access its operations. */
    private final SigningCertificatesImpl signingCertificates;

    /**
     * Gets the SigningCertificatesImpl object to access its operations.
     *
     * @return the SigningCertificatesImpl object.
     */
    public SigningCertificatesImpl getSigningCertificates() {
        return this.signingCertificates;
    }

    /** The MetadataConfigurationsImpl object to access its operations. */
    private final MetadataConfigurationsImpl metadataConfigurations;

    /**
     * Gets the MetadataConfigurationsImpl object to access its operations.
     *
     * @return the MetadataConfigurationsImpl object.
     */
    public MetadataConfigurationsImpl getMetadataConfigurations() {
        return this.metadataConfigurations;
    }

    /**
     * Initializes an instance of AttestationClient client.
     *
     * @param instanceUrl The attestation instance base URI, for example https://mytenant.attest.azure.net.
     * @param apiVersion Api Version.
     */
    public AttestationClientImpl(String instanceUrl, String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                instanceUrl,
                apiVersion);
    }

    /**
     * Initializes an instance of AttestationClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param instanceUrl The attestation instance base URI, for example https://mytenant.attest.azure.net.
     * @param apiVersion Api Version.
     */
    public AttestationClientImpl(HttpPipeline httpPipeline, String instanceUrl, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), instanceUrl, apiVersion);
    }

    /**
     * Initializes an instance of AttestationClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param instanceUrl The attestation instance base URI, for example https://mytenant.attest.azure.net.
     * @param apiVersion Api Version.
     */
    public AttestationClientImpl(
            HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String instanceUrl, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.instanceUrl = instanceUrl;
        this.apiVersion = apiVersion;
        this.policies = new PoliciesImpl(this);
        this.policyCertificates = new PolicyCertificatesImpl(this);
        this.attestations = new AttestationsImpl(this);
        this.signingCertificates = new SigningCertificatesImpl(this);
        this.metadataConfigurations = new MetadataConfigurationsImpl(this);
    }
}
