/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorThreshold;
import com.azure.search.documents.models.VectorThresholdKind;
import java.io.IOException;

public final class SearchScoreThreshold
extends VectorThreshold {
    private VectorThresholdKind kind = VectorThresholdKind.SEARCH_SCORE;
    private final double value;

    public SearchScoreThreshold(double value) {
        this.value = value;
    }

    @Override
    public VectorThresholdKind getKind() {
        return this.kind;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("value", this.value);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchScoreThreshold fromJson(JsonReader jsonReader) throws IOException {
        return (SearchScoreThreshold)jsonReader.readObject(reader -> {
            boolean valueFound = false;
            double value = 0.0;
            VectorThresholdKind kind = VectorThresholdKind.SEARCH_SCORE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    value = reader.getDouble();
                    valueFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorThresholdKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (valueFound) {
                SearchScoreThreshold deserializedSearchScoreThreshold = new SearchScoreThreshold(value);
                deserializedSearchScoreThreshold.kind = kind;
                return deserializedSearchScoreThreshold;
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

