/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FacetResult
implements JsonSerializable<FacetResult> {
    private Long count;
    private Double sum;
    private Map<String, List<FacetResult>> facets;
    private Map<String, Object> additionalProperties;

    public Long getCount() {
        return this.count;
    }

    public Double getSum() {
        return this.sum;
    }

    public Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public FacetResult setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FacetResult fromJson(JsonReader jsonReader) throws IOException {
        return (FacetResult)jsonReader.readObject(reader -> {
            FacetResult deserializedFacetResult = new FacetResult();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedFacetResult.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sum".equals(fieldName)) {
                    deserializedFacetResult.sum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("@search.facets".equals(fieldName)) {
                    Map facets;
                    deserializedFacetResult.facets = facets = reader.readMap(reader1 -> reader1.readArray(reader2 -> FacetResult.fromJson(reader2)));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedFacetResult.additionalProperties = additionalProperties;
            return deserializedFacetResult;
        });
    }
}

