/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchIndexerIndexProjectionSelector
implements JsonSerializable<SearchIndexerIndexProjectionSelector> {
    private final String targetIndexName;
    private final String parentKeyFieldName;
    private final String sourceContext;
    private final List<InputFieldMappingEntry> mappings;

    public SearchIndexerIndexProjectionSelector(String targetIndexName, String parentKeyFieldName, String sourceContext, List<InputFieldMappingEntry> mappings) {
        this.targetIndexName = targetIndexName;
        this.parentKeyFieldName = parentKeyFieldName;
        this.sourceContext = sourceContext;
        this.mappings = mappings;
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public String getParentKeyFieldName() {
        return this.parentKeyFieldName;
    }

    public String getSourceContext() {
        return this.sourceContext;
    }

    public List<InputFieldMappingEntry> getMappings() {
        return this.mappings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetIndexName", this.targetIndexName);
        jsonWriter.writeStringField("parentKeyFieldName", this.parentKeyFieldName);
        jsonWriter.writeStringField("sourceContext", this.sourceContext);
        jsonWriter.writeArrayField("mappings", this.mappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerIndexProjectionSelector fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerIndexProjectionSelector)jsonReader.readObject(reader -> {
            boolean targetIndexNameFound = false;
            String targetIndexName = null;
            boolean parentKeyFieldNameFound = false;
            String parentKeyFieldName = null;
            boolean sourceContextFound = false;
            String sourceContext = null;
            boolean mappingsFound = false;
            List mappings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetIndexName".equals(fieldName)) {
                    targetIndexName = reader.getString();
                    targetIndexNameFound = true;
                    continue;
                }
                if ("parentKeyFieldName".equals(fieldName)) {
                    parentKeyFieldName = reader.getString();
                    parentKeyFieldNameFound = true;
                    continue;
                }
                if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                    sourceContextFound = true;
                    continue;
                }
                if ("mappings".equals(fieldName)) {
                    mappings = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    mappingsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (targetIndexNameFound && parentKeyFieldNameFound && sourceContextFound && mappingsFound) {
                return new SearchIndexerIndexProjectionSelector(targetIndexName, parentKeyFieldName, sourceContext, mappings);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!targetIndexNameFound) {
                missingProperties.add("targetIndexName");
            }
            if (!parentKeyFieldNameFound) {
                missingProperties.add("parentKeyFieldName");
            }
            if (!sourceContextFound) {
                missingProperties.add("sourceContext");
            }
            if (!mappingsFound) {
                missingProperties.add("mappings");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

