/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.FieldMapping;
import com.azure.search.documents.indexes.models.IndexingParameters;
import com.azure.search.documents.indexes.models.IndexingSchedule;
import com.azure.search.documents.indexes.models.SearchIndexerCache;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class SearchIndexer
implements JsonSerializable<SearchIndexer> {
    private final String name;
    private String description;
    private String dataSourceName;
    private String skillsetName;
    private String targetIndexName;
    private IndexingSchedule schedule;
    private IndexingParameters parameters;
    private List<FieldMapping> fieldMappings;
    private List<FieldMapping> outputFieldMappings;
    private Boolean isDisabled;
    private String eTag;
    private SearchResourceEncryptionKey encryptionKey;
    private SearchIndexerCache cache;

    public SearchIndexer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexer setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public SearchIndexer setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public String getSkillsetName() {
        return this.skillsetName;
    }

    public SearchIndexer setSkillsetName(String skillsetName) {
        this.skillsetName = skillsetName;
        return this;
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public SearchIndexer setTargetIndexName(String targetIndexName) {
        this.targetIndexName = targetIndexName;
        return this;
    }

    public IndexingSchedule getSchedule() {
        return this.schedule;
    }

    public SearchIndexer setSchedule(IndexingSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public IndexingParameters getParameters() {
        return this.parameters;
    }

    public SearchIndexer setParameters(IndexingParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public SearchIndexer setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
        return this;
    }

    public List<FieldMapping> getOutputFieldMappings() {
        return this.outputFieldMappings;
    }

    public SearchIndexer setOutputFieldMappings(List<FieldMapping> outputFieldMappings) {
        this.outputFieldMappings = outputFieldMappings;
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public SearchIndexer setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndexer setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SearchIndexer setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public SearchIndexerCache getCache() {
        return this.cache;
    }

    public SearchIndexer setCache(SearchIndexerCache cache) {
        this.cache = cache;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("dataSourceName", this.dataSourceName);
        jsonWriter.writeStringField("skillsetName", this.skillsetName);
        jsonWriter.writeStringField("targetIndexName", this.targetIndexName);
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeArrayField("fieldMappings", this.fieldMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputFieldMappings", this.outputFieldMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disabled", this.isDisabled);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        jsonWriter.writeJsonField("cache", (JsonSerializable)this.cache);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexer fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String dataSourceName = null;
            String skillsetName = null;
            String targetIndexName = null;
            IndexingSchedule schedule = null;
            IndexingParameters parameters = null;
            List fieldMappings = null;
            List outputFieldMappings = null;
            Boolean isDisabled = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            SearchIndexerCache cache = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("dataSourceName".equals(fieldName)) {
                    dataSourceName = reader.getString();
                    continue;
                }
                if ("skillsetName".equals(fieldName)) {
                    skillsetName = reader.getString();
                    continue;
                }
                if ("targetIndexName".equals(fieldName)) {
                    targetIndexName = reader.getString();
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    schedule = IndexingSchedule.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = IndexingParameters.fromJson(reader);
                    continue;
                }
                if ("fieldMappings".equals(fieldName)) {
                    fieldMappings = reader.readArray(reader1 -> FieldMapping.fromJson(reader1));
                    continue;
                }
                if ("outputFieldMappings".equals(fieldName)) {
                    outputFieldMappings = reader.readArray(reader1 -> FieldMapping.fromJson(reader1));
                    continue;
                }
                if ("disabled".equals(fieldName)) {
                    isDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("cache".equals(fieldName)) {
                    cache = SearchIndexerCache.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                SearchIndexer deserializedSearchIndexer = new SearchIndexer(name);
                deserializedSearchIndexer.description = description;
                deserializedSearchIndexer.dataSourceName = dataSourceName;
                deserializedSearchIndexer.skillsetName = skillsetName;
                deserializedSearchIndexer.targetIndexName = targetIndexName;
                deserializedSearchIndexer.schedule = schedule;
                deserializedSearchIndexer.parameters = parameters;
                deserializedSearchIndexer.fieldMappings = fieldMappings;
                deserializedSearchIndexer.outputFieldMappings = outputFieldMappings;
                deserializedSearchIndexer.isDisabled = isDisabled;
                deserializedSearchIndexer.eTag = eTag;
                deserializedSearchIndexer.encryptionKey = encryptionKey;
                deserializedSearchIndexer.cache = cache;
                return deserializedSearchIndexer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public SearchIndexer(String name, String dataSourceName, String targetIndexName) {
        this.name = name;
        this.dataSourceName = dataSourceName;
        this.targetIndexName = targetIndexName;
    }

    public SearchIndexer setFieldMappings(FieldMapping ... fieldMappings) {
        this.fieldMappings = fieldMappings == null ? null : Arrays.asList(fieldMappings);
        return this;
    }

    public SearchIndexer setOutputFieldMappings(FieldMapping ... outputFieldMappings) {
        this.outputFieldMappings = outputFieldMappings == null ? null : Arrays.asList(outputFieldMappings);
        return this;
    }
}

