/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import com.azure.search.documents.indexes.models.KnowledgeSourceKind;
import com.azure.search.documents.indexes.models.SearchIndexKnowledgeSourceParameters;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchIndexKnowledgeSource
extends KnowledgeSource {
    private KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
    private final SearchIndexKnowledgeSourceParameters searchIndexParameters;

    public SearchIndexKnowledgeSource(String name, SearchIndexKnowledgeSourceParameters searchIndexParameters) {
        super(name);
        this.searchIndexParameters = searchIndexParameters;
    }

    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    public SearchIndexKnowledgeSourceParameters getSearchIndexParameters() {
        return this.searchIndexParameters;
    }

    @Override
    public SearchIndexKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SearchIndexKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    @Override
    public SearchIndexKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("@odata.etag", this.getETag());
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.getEncryptionKey());
        jsonWriter.writeJsonField("searchIndexParameters", (JsonSerializable)this.searchIndexParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexKnowledgeSource)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean searchIndexParametersFound = false;
            SearchIndexKnowledgeSourceParameters searchIndexParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("searchIndexParameters".equals(fieldName)) {
                    searchIndexParameters = SearchIndexKnowledgeSourceParameters.fromJson(reader);
                    searchIndexParametersFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && searchIndexParametersFound) {
                SearchIndexKnowledgeSource deserializedSearchIndexKnowledgeSource = new SearchIndexKnowledgeSource(name, searchIndexParameters);
                deserializedSearchIndexKnowledgeSource.setDescription(description);
                deserializedSearchIndexKnowledgeSource.setETag(eTag);
                deserializedSearchIndexKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedSearchIndexKnowledgeSource.kind = kind;
                return deserializedSearchIndexKnowledgeSource;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!searchIndexParametersFound) {
                missingProperties.add("searchIndexParameters");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

