/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeAgentAzureOpenAIModel;
import com.azure.search.documents.indexes.models.KnowledgeAgentModelKind;
import java.io.IOException;

public class KnowledgeAgentModel
implements JsonSerializable<KnowledgeAgentModel> {
    private KnowledgeAgentModelKind kind = KnowledgeAgentModelKind.fromString("KnowledgeAgentModel");

    public KnowledgeAgentModelKind getKind() {
        return this.kind;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentModel fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentModel)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeAgentModel knowledgeAgentModel;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("azureOpenAI".equals(discriminatorValue)) {
                    knowledgeAgentModel = KnowledgeAgentAzureOpenAIModel.fromJson(readerToUse.reset());
                    return knowledgeAgentModel;
                }
                knowledgeAgentModel = KnowledgeAgentModel.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeAgentModel;
            }
        });
    }

    static KnowledgeAgentModel fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentModel)jsonReader.readObject(reader -> {
            KnowledgeAgentModel deserializedKnowledgeAgentModel = new KnowledgeAgentModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeAgentModel.kind = KnowledgeAgentModelKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKnowledgeAgentModel;
        });
    }
}

