/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.indexes.models.IndexingParametersConfiguration;
import java.io.IOException;
import java.util.Map;

public final class IndexingParameters
implements JsonSerializable<IndexingParameters> {
    private Integer batchSize;
    private Integer maxFailedItems;
    private Integer maxFailedItemsPerBatch;
    private IndexingParametersConfiguration configuration;
    private Map<String, Object> configurationMap;

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public IndexingParameters setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getMaxFailedItems() {
        return this.maxFailedItems;
    }

    public IndexingParameters setMaxFailedItems(Integer maxFailedItems) {
        this.maxFailedItems = maxFailedItems;
        return this;
    }

    public Integer getMaxFailedItemsPerBatch() {
        return this.maxFailedItemsPerBatch;
    }

    public IndexingParameters setMaxFailedItemsPerBatch(Integer maxFailedItemsPerBatch) {
        this.maxFailedItemsPerBatch = maxFailedItemsPerBatch;
        return this;
    }

    public IndexingParametersConfiguration getIndexingParametersConfiguration() {
        return this.configuration;
    }

    public IndexingParameters setIndexingParametersConfiguration(IndexingParametersConfiguration configuration) {
        this.configuration = configuration;
        this.configurationMap = MappingUtils.indexingParametersConfigurationToMap(configuration);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("batchSize", (Number)this.batchSize);
        jsonWriter.writeNumberField("maxFailedItems", (Number)this.maxFailedItems);
        jsonWriter.writeNumberField("maxFailedItemsPerBatch", (Number)this.maxFailedItemsPerBatch);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        return jsonWriter.writeEndObject();
    }

    public static IndexingParameters fromJson(JsonReader jsonReader) throws IOException {
        return (IndexingParameters)jsonReader.readObject(reader -> {
            IndexingParameters deserializedIndexingParameters = new IndexingParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("batchSize".equals(fieldName)) {
                    deserializedIndexingParameters.batchSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxFailedItems".equals(fieldName)) {
                    deserializedIndexingParameters.maxFailedItems = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxFailedItemsPerBatch".equals(fieldName)) {
                    deserializedIndexingParameters.maxFailedItemsPerBatch = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedIndexingParameters.configuration = IndexingParametersConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIndexingParameters;
        });
    }

    public Map<String, Object> getConfiguration() {
        return this.configurationMap;
    }

    public IndexingParameters setConfiguration(Map<String, Object> configuration) {
        this.configurationMap = configuration;
        this.configuration = MappingUtils.mapToIndexingParametersConfiguration(configuration);
        return this;
    }
}

