/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CustomEntityAlias
implements JsonSerializable<CustomEntityAlias> {
    private final String text;
    private Boolean caseSensitive;
    private Boolean accentSensitive;
    private Integer fuzzyEditDistance;

    public CustomEntityAlias(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public CustomEntityAlias setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Boolean isAccentSensitive() {
        return this.accentSensitive;
    }

    public CustomEntityAlias setAccentSensitive(Boolean accentSensitive) {
        this.accentSensitive = accentSensitive;
        return this;
    }

    public Integer getFuzzyEditDistance() {
        return this.fuzzyEditDistance;
    }

    public CustomEntityAlias setFuzzyEditDistance(Integer fuzzyEditDistance) {
        this.fuzzyEditDistance = fuzzyEditDistance;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeBooleanField("caseSensitive", this.caseSensitive);
        jsonWriter.writeBooleanField("accentSensitive", this.accentSensitive);
        jsonWriter.writeNumberField("fuzzyEditDistance", (Number)this.fuzzyEditDistance);
        return jsonWriter.writeEndObject();
    }

    public static CustomEntityAlias fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntityAlias)jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            Boolean caseSensitive = null;
            Boolean accentSensitive = null;
            Integer fuzzyEditDistance = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if ("caseSensitive".equals(fieldName)) {
                    caseSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("accentSensitive".equals(fieldName)) {
                    accentSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fuzzyEditDistance".equals(fieldName)) {
                    fuzzyEditDistance = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (textFound) {
                CustomEntityAlias deserializedCustomEntityAlias = new CustomEntityAlias(text);
                deserializedCustomEntityAlias.caseSensitive = caseSensitive;
                deserializedCustomEntityAlias.accentSensitive = accentSensitive;
                deserializedCustomEntityAlias.fuzzyEditDistance = fuzzyEditDistance;
                return deserializedCustomEntityAlias;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}

