/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CommonModelParameters
implements JsonSerializable<CommonModelParameters> {
    private String model;
    private Float frequencyPenalty;
    private Float presencePenalty;
    private Integer maxTokens;
    private Float temperature;
    private Integer seed;
    private List<String> stop;

    public String getModel() {
        return this.model;
    }

    public CommonModelParameters setModel(String model) {
        this.model = model;
        return this;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public CommonModelParameters setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public CommonModelParameters setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public CommonModelParameters setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public CommonModelParameters setTemperature(Float temperature) {
        this.temperature = temperature;
        return this;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public CommonModelParameters setSeed(Integer seed) {
        this.seed = seed;
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public CommonModelParameters setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("frequencyPenalty", (Number)this.frequencyPenalty);
        jsonWriter.writeNumberField("presencePenalty", (Number)this.presencePenalty);
        jsonWriter.writeNumberField("maxTokens", (Number)this.maxTokens);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("seed", (Number)this.seed);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CommonModelParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CommonModelParameters)jsonReader.readObject(reader -> {
            CommonModelParameters deserializedCommonModelParameters = new CommonModelParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    deserializedCommonModelParameters.model = reader.getString();
                    continue;
                }
                if ("frequencyPenalty".equals(fieldName)) {
                    deserializedCommonModelParameters.frequencyPenalty = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("presencePenalty".equals(fieldName)) {
                    deserializedCommonModelParameters.presencePenalty = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("maxTokens".equals(fieldName)) {
                    deserializedCommonModelParameters.maxTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    deserializedCommonModelParameters.temperature = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("seed".equals(fieldName)) {
                    deserializedCommonModelParameters.seed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    List stop;
                    deserializedCommonModelParameters.stop = stop = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommonModelParameters;
        });
    }
}

