/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.IndexingSchedule;
import com.azure.search.documents.indexes.models.KnowledgeAgentModel;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class AzureBlobKnowledgeSourceParameters
implements JsonSerializable<AzureBlobKnowledgeSourceParameters> {
    private SearchIndexerDataIdentity identity;
    private final String connectionString;
    private final String containerName;
    private String folderPath;
    private VectorSearchVectorizer embeddingModel;
    private KnowledgeAgentModel chatCompletionModel;
    private IndexingSchedule ingestionSchedule;
    private Map<String, String> createdResources;
    private Boolean disableImageVerbalization;

    public AzureBlobKnowledgeSourceParameters(String connectionString, String containerName) {
        this.connectionString = connectionString;
        this.containerName = containerName;
    }

    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    public AzureBlobKnowledgeSourceParameters setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public AzureBlobKnowledgeSourceParameters setFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public VectorSearchVectorizer getEmbeddingModel() {
        return this.embeddingModel;
    }

    public AzureBlobKnowledgeSourceParameters setEmbeddingModel(VectorSearchVectorizer embeddingModel) {
        this.embeddingModel = embeddingModel;
        return this;
    }

    public KnowledgeAgentModel getChatCompletionModel() {
        return this.chatCompletionModel;
    }

    public AzureBlobKnowledgeSourceParameters setChatCompletionModel(KnowledgeAgentModel chatCompletionModel) {
        this.chatCompletionModel = chatCompletionModel;
        return this;
    }

    public IndexingSchedule getIngestionSchedule() {
        return this.ingestionSchedule;
    }

    public AzureBlobKnowledgeSourceParameters setIngestionSchedule(IndexingSchedule ingestionSchedule) {
        this.ingestionSchedule = ingestionSchedule;
        return this;
    }

    public Map<String, String> getCreatedResources() {
        return this.createdResources;
    }

    public Boolean isDisableImageVerbalization() {
        return this.disableImageVerbalization;
    }

    public AzureBlobKnowledgeSourceParameters setDisableImageVerbalization(Boolean disableImageVerbalization) {
        this.disableImageVerbalization = disableImageVerbalization;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeJsonField("embeddingModel", (JsonSerializable)this.embeddingModel);
        jsonWriter.writeJsonField("chatCompletionModel", (JsonSerializable)this.chatCompletionModel);
        jsonWriter.writeJsonField("ingestionSchedule", (JsonSerializable)this.ingestionSchedule);
        jsonWriter.writeBooleanField("disableImageVerbalization", this.disableImageVerbalization);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobKnowledgeSourceParameters)jsonReader.readObject(reader -> {
            boolean connectionStringFound = false;
            String connectionString = null;
            boolean containerNameFound = false;
            String containerName = null;
            SearchIndexerDataIdentity identity = null;
            String folderPath = null;
            VectorSearchVectorizer embeddingModel = null;
            KnowledgeAgentModel chatCompletionModel = null;
            IndexingSchedule ingestionSchedule = null;
            Map createdResources = null;
            Boolean disableImageVerbalization = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    connectionString = reader.getString();
                    connectionStringFound = true;
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    containerName = reader.getString();
                    containerNameFound = true;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    folderPath = reader.getString();
                    continue;
                }
                if ("embeddingModel".equals(fieldName)) {
                    embeddingModel = VectorSearchVectorizer.fromJson(reader);
                    continue;
                }
                if ("chatCompletionModel".equals(fieldName)) {
                    chatCompletionModel = KnowledgeAgentModel.fromJson(reader);
                    continue;
                }
                if ("ingestionSchedule".equals(fieldName)) {
                    ingestionSchedule = IndexingSchedule.fromJson(reader);
                    continue;
                }
                if ("createdResources".equals(fieldName)) {
                    createdResources = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableImageVerbalization".equals(fieldName)) {
                    disableImageVerbalization = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (connectionStringFound && containerNameFound) {
                AzureBlobKnowledgeSourceParameters deserializedAzureBlobKnowledgeSourceParameters = new AzureBlobKnowledgeSourceParameters(connectionString, containerName);
                deserializedAzureBlobKnowledgeSourceParameters.identity = identity;
                deserializedAzureBlobKnowledgeSourceParameters.folderPath = folderPath;
                deserializedAzureBlobKnowledgeSourceParameters.embeddingModel = embeddingModel;
                deserializedAzureBlobKnowledgeSourceParameters.chatCompletionModel = chatCompletionModel;
                deserializedAzureBlobKnowledgeSourceParameters.ingestionSchedule = ingestionSchedule;
                deserializedAzureBlobKnowledgeSourceParameters.createdResources = createdResources;
                deserializedAzureBlobKnowledgeSourceParameters.disableImageVerbalization = disableImageVerbalization;
                return deserializedAzureBlobKnowledgeSourceParameters;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!connectionStringFound) {
                missingProperties.add("connectionString");
            }
            if (!containerNameFound) {
                missingProperties.add("containerName");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

