/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class AsciiFoldingTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter";
    private Boolean preserveOriginal;

    public AsciiFoldingTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Boolean isPreserveOriginal() {
        return this.preserveOriginal;
    }

    public AsciiFoldingTokenFilter setPreserveOriginal(Boolean preserveOriginal) {
        this.preserveOriginal = preserveOriginal;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("preserveOriginal", this.preserveOriginal);
        return jsonWriter.writeEndObject();
    }

    public static AsciiFoldingTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (AsciiFoldingTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter";
            Boolean preserveOriginal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("preserveOriginal".equals(fieldName)) {
                    preserveOriginal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                AsciiFoldingTokenFilter deserializedAsciiFoldingTokenFilter = new AsciiFoldingTokenFilter(name);
                deserializedAsciiFoldingTokenFilter.odataType = odataType;
                deserializedAsciiFoldingTokenFilter.preserveOriginal = preserveOriginal;
                return deserializedAsciiFoldingTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

