/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;
import java.util.ArrayList;

public final class AIServicesVisionParameters
implements JsonSerializable<AIServicesVisionParameters> {
    private final String modelVersion;
    private final String resourceUri;
    private String apiKey;
    private SearchIndexerDataIdentity authIdentity;

    public AIServicesVisionParameters(String modelVersion, String resourceUri) {
        this.modelVersion = modelVersion;
        this.resourceUri = resourceUri;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public AIServicesVisionParameters setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    public AIServicesVisionParameters setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeStringField("resourceUri", this.resourceUri);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    public static AIServicesVisionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AIServicesVisionParameters)jsonReader.readObject(reader -> {
            boolean modelVersionFound = false;
            String modelVersion = null;
            boolean resourceUriFound = false;
            String resourceUri = null;
            String apiKey = null;
            SearchIndexerDataIdentity authIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    modelVersionFound = true;
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    resourceUri = reader.getString();
                    resourceUriFound = true;
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (modelVersionFound && resourceUriFound) {
                AIServicesVisionParameters deserializedAIServicesVisionParameters = new AIServicesVisionParameters(modelVersion, resourceUri);
                deserializedAIServicesVisionParameters.apiKey = apiKey;
                deserializedAIServicesVisionParameters.authIdentity = authIdentity;
                return deserializedAIServicesVisionParameters;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!modelVersionFound) {
                missingProperties.add("modelVersion");
            }
            if (!resourceUriFound) {
                missingProperties.add("resourceUri");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

