/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.KnowledgeAgent;
import java.io.IOException;
import java.util.List;

public final class ListKnowledgeAgentsResult
implements JsonSerializable<ListKnowledgeAgentsResult> {
    private final List<KnowledgeAgent> knowledgeAgents;

    public ListKnowledgeAgentsResult(List<KnowledgeAgent> knowledgeAgents) {
        this.knowledgeAgents = knowledgeAgents;
    }

    public List<KnowledgeAgent> getKnowledgeAgents() {
        return this.knowledgeAgents;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.knowledgeAgents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ListKnowledgeAgentsResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListKnowledgeAgentsResult)jsonReader.readObject(reader -> {
            boolean knowledgeAgentsFound = false;
            List knowledgeAgents = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    knowledgeAgents = reader.readArray(reader1 -> KnowledgeAgent.fromJson(reader1));
                    knowledgeAgentsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (knowledgeAgentsFound) {
                return new ListKnowledgeAgentsResult(knowledgeAgents);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

