/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListKnowledgeAgentsResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.KnowledgeAgent;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class KnowledgeAgentsImpl {
    private final KnowledgeAgentsService service;
    private final SearchServiceClientImpl client;

    KnowledgeAgentsImpl(SearchServiceClientImpl client) {
        this.service = (KnowledgeAgentsService)RestProxy.create(KnowledgeAgentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createOrUpdateWithResponseAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createOrUpdateWithResponseAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeAgent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createOrUpdateAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createOrUpdateAsync(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> createOrUpdateWithResponse(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeAgent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent createOrUpdate(String agentName, KnowledgeAgent knowledgeAgent, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return (KnowledgeAgent)this.createOrUpdateWithResponse(agentName, knowledgeAgent, ifMatch, ifNoneMatch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(agentName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), agentName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String agentName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(agentName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> getWithResponseAsync(String agentName, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.getWithResponseAsync(agentName, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> getWithResponseAsync(String agentName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), agentName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> getAsync(String agentName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(agentName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> getAsync(String agentName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(agentName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> getWithResponse(String agentName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), agentName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent get(String agentName, RequestOptions requestOptions) {
        return (KnowledgeAgent)this.getWithResponse(agentName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeAgent>> listSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeAgentsResult)res.getValue()).getKnowledgeAgents(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KnowledgeAgent>> listSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeAgentsResult)res.getValue()).getKnowledgeAgents(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KnowledgeAgent> listAsync(RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KnowledgeAgent> listAsync(RequestOptions requestOptions, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KnowledgeAgent> listSinglePage(RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeAgentsResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeAgentsResult)res.getValue()).getKnowledgeAgents(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KnowledgeAgent> listSinglePage(RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        Response<ListKnowledgeAgentsResult> res = this.service.listSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListKnowledgeAgentsResult)res.getValue()).getKnowledgeAgents(), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> list(RequestOptions requestOptions) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> list(RequestOptions requestOptions, Context context) {
        return new PagedIterable(() -> this.listSinglePage(requestOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createWithResponseAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(knowledgeAgent, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgent>> createWithResponseAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeAgent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions) {
        return this.createWithResponseAsync(knowledgeAgent, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgent> createAsync(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(knowledgeAgent, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((KnowledgeAgent)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> createWithResponse(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", knowledgeAgent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent create(KnowledgeAgent knowledgeAgent, RequestOptions requestOptions) {
        return (KnowledgeAgent)this.createWithResponse(knowledgeAgent, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientKnowledgeAgents")
    public static interface KnowledgeAgentsService {
        @Put(value="/agents('{agentName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeAgent>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") KnowledgeAgent var9, Context var10);

        @Put(value="/agents('{agentName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeAgent> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") KnowledgeAgent var9, Context var10);

        @Delete(value="/agents('{agentName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/agents('{agentName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/agents('{agentName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeAgent>> get(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/agents('{agentName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeAgent> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="agentName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/agents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListKnowledgeAgentsResult>> list(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/agents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListKnowledgeAgentsResult> listSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/agents")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<KnowledgeAgent>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") KnowledgeAgent var5, Context var6);

        @Post(value="/agents")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<KnowledgeAgent> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") KnowledgeAgent var5, Context var6);
    }
}

