/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchClient;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.converters.AnalyzeRequestConverter;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.SearchIndexAsyncClient;
import com.azure.search.documents.indexes.SearchIndexClientBuilder;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.FieldBuilderOptions;
import com.azure.search.documents.indexes.models.IndexStatisticsSummary;
import com.azure.search.documents.indexes.models.KnowledgeAgent;
import com.azure.search.documents.indexes.models.KnowledgeSource;
import com.azure.search.documents.indexes.models.SearchAlias;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=SearchIndexClientBuilder.class)
public final class SearchIndexClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final SearchServiceClientImpl restClient;
    private final JsonSerializer serializer;
    private final HttpPipeline httpPipeline;

    SearchIndexClient(String endpoint, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer) {
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.restClient = new SearchServiceClientImpl(httpPipeline, endpoint, serviceVersion.getVersion());
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SearchClient getSearchClient(String indexName) {
        return SearchIndexAsyncClient.getSearchClientBuilder(indexName, this.endpoint, this.serviceVersion, this.httpPipeline, this.serializer).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex createIndex(SearchIndex index) {
        return (SearchIndex)this.createIndexWithResponse(index, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> createIndexWithResponse(SearchIndex index, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Objects.requireNonNull(index, "'Index' cannot be null");
            return this.restClient.getIndexes().createWithResponse(index, null, context);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex getIndex(String indexName) {
        return (SearchIndex)this.getIndexWithResponse(indexName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> getIndexWithResponse(String indexName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexes().getWithResponse(indexName, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndexStatistics getIndexStatistics(String indexName) {
        return (SearchIndexStatistics)this.getIndexStatisticsWithResponse(indexName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndexStatistics> getIndexStatisticsWithResponse(String indexName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexes().getStatisticsWithResponse(indexName, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> listIndexes() {
        return this.listIndexes(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SearchIndex> listIndexes(Context context) {
        try {
            return new PagedIterable(() -> this.listIndexesWithResponse(null, context));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private PagedResponse<SearchIndex> listIndexesWithResponse(String select, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexes().listSinglePage(select, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexNames() {
        return this.listIndexNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listIndexNames(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mapPagedSearchIndexNames(this.listIndexesWithResponse("name", context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchIndex createOrUpdateIndex(SearchIndex index) {
        return (SearchIndex)this.createOrUpdateIndexWithResponse(index, false, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchIndex> createOrUpdateIndexWithResponse(SearchIndex index, boolean allowIndexDowntime, boolean onlyIfUnchanged, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Objects.requireNonNull(index, "'Index' cannot null.");
            String ifMatch = onlyIfUnchanged ? index.getETag() : null;
            return this.restClient.getIndexes().createOrUpdateWithResponse(index.getName(), index, allowIndexDowntime, ifMatch, null, null, context);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteIndex(String indexName) {
        Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexes().deleteWithResponse(indexName, null, null, null, Context.NONE), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexWithResponse(SearchIndex index, boolean onlyIfUnchanged, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            String etag = onlyIfUnchanged ? index.getETag() : null;
            return this.restClient.getIndexes().deleteWithResponse(index.getName(), etag, null, null, context);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions) {
        return this.analyzeText(indexName, analyzeTextOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions, Context context) {
        try {
            return new PagedIterable(() -> this.analyzeTextWithResponse(indexName, analyzeTextOptions, context));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private PagedResponse<AnalyzedTokenInfo> analyzeTextWithResponse(String indexName, AnalyzeTextOptions analyzeTextOptions, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> MappingUtils.mapPagedTokenInfos(this.restClient.getIndexes().analyzeWithResponse(indexName, AnalyzeRequestConverter.map(analyzeTextOptions), null, context)), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap createSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createSynonymMapWithResponse(synonymMap, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createSynonymMapWithResponse(SynonymMap synonymMap, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Objects.requireNonNull(synonymMap, "'synonymMap' cannot be null.");
            return this.restClient.getSynonymMaps().createWithResponse(synonymMap, null, context);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap getSynonymMap(String synonymMapName) {
        return (SynonymMap)this.getSynonymMapWithResponse(synonymMapName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> getSynonymMapWithResponse(String synonymMapName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSynonymMaps().getWithResponse(synonymMapName, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SynonymMap> listSynonymMaps() {
        return this.listSynonymMaps(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SynonymMap> listSynonymMaps(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mapPagedSynonymMaps(this.listSynonymMapsWithResponse(null, context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    private Response<ListSynonymMapsResult> listSynonymMapsWithResponse(String select, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSynonymMaps().listWithResponse(select, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSynonymMapNames() {
        return this.listSynonymMapNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listSynonymMapNames(Context context) {
        try {
            return new PagedIterable(() -> MappingUtils.mapPagedSynonymMapNames(this.listSynonymMapsWithResponse("name", context)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap createOrUpdateSynonymMap(SynonymMap synonymMap) {
        return (SynonymMap)this.createOrUpdateSynonymMapWithResponse(synonymMap, false, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createOrUpdateSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Objects.requireNonNull(synonymMap, "'synonymMap' cannot be null.");
            String ifMatch = onlyIfUnchanged ? synonymMap.getETag() : null;
            return this.restClient.getSynonymMaps().createOrUpdateWithResponse(synonymMap.getName(), synonymMap, ifMatch, null, null, context);
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSynonymMap(String synonymMapName) {
        Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSynonymMaps().deleteWithResponse(synonymMapName, null, null, null, Context.NONE), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        String etag = onlyIfUnchanged ? synonymMap.getETag() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getSynonymMaps().deleteWithResponse(synonymMap.getName(), etag, null, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SearchServiceStatistics getServiceStatistics() {
        return (SearchServiceStatistics)this.getServiceStatisticsWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SearchServiceStatistics> getServiceStatisticsWithResponse(Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getServiceStatisticsWithResponse(null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IndexStatisticsSummary> getIndexStatsSummary() {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexStatsSummary(null), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IndexStatisticsSummary> getIndexStatsSummary(Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getIndexStatsSummary(null, context), LOGGER);
    }

    public static List<SearchField> buildSearchFields(Class<?> model, FieldBuilderOptions options) {
        return SearchIndexAsyncClient.buildSearchFields(model, options);
    }

    public SearchAlias createAlias(SearchAlias alias) {
        return (SearchAlias)this.createAliasWithResponse(alias, Context.NONE).getValue();
    }

    public Response<SearchAlias> createAliasWithResponse(SearchAlias alias, Context context) {
        try {
            return this.restClient.getAliases().createWithResponse(alias, null, context);
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    public SearchAlias createOrUpdateAlias(SearchAlias alias) {
        return (SearchAlias)this.createOrUpdateAliasWithResponse(alias, false, Context.NONE).getValue();
    }

    public Response<SearchAlias> createOrUpdateAliasWithResponse(SearchAlias alias, boolean onlyIfUnchanged, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getAliases().createOrUpdateWithResponse(alias.getName(), alias, onlyIfUnchanged ? alias.getETag() : null, null, null, context), LOGGER);
    }

    public SearchAlias getAlias(String aliasName) {
        return (SearchAlias)this.getAliasWithResponse(aliasName, Context.NONE).getValue();
    }

    public Response<SearchAlias> getAliasWithResponse(String aliasName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getAliases().getWithResponse(aliasName, null, context), LOGGER);
    }

    public void deleteAlias(String aliasName) {
        this.deleteAliasWithResponse(aliasName, null, Context.NONE);
    }

    public Response<Void> deleteAliasWithResponse(SearchAlias alias, boolean onlyIfUnchanged, Context context) {
        return this.deleteAliasWithResponse(alias.getName(), onlyIfUnchanged ? alias.getETag() : null, context);
    }

    Response<Void> deleteAliasWithResponse(String aliasName, String eTag, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getAliases().deleteWithResponse(aliasName, eTag, null, null, context), LOGGER);
    }

    public PagedIterable<SearchAlias> listAliases() {
        return this.listAliases(Context.NONE);
    }

    public PagedIterable<SearchAlias> listAliases(Context context) {
        try {
            return new PagedIterable(() -> this.restClient.getAliases().listSinglePage(null, context));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent createKnowledgeAgent(KnowledgeAgent knowledgeAgent) {
        return (KnowledgeAgent)this.createKnowledgeAgentWithResponse(knowledgeAgent, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> createKnowledgeAgentWithResponse(KnowledgeAgent knowledgeAgent, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeAgents().createWithResponse(knowledgeAgent, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent createOrUpdateKnowledgeAgent(KnowledgeAgent knowledgeAgent) {
        return (KnowledgeAgent)this.createOrUpdateKnowledgeAgentWithResponse(knowledgeAgent, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> createOrUpdateKnowledgeAgentWithResponse(KnowledgeAgent knowledgeAgent, MatchConditions matchConditions, Context context) {
        String ifMatch = matchConditions != null ? matchConditions.getIfMatch() : null;
        String ifNoneMatch = matchConditions != null ? matchConditions.getIfNoneMatch() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeAgents().createOrUpdateWithResponse(knowledgeAgent.getName(), knowledgeAgent, ifMatch, ifNoneMatch, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeAgent getKnowledgeAgent(String agentName) {
        return (KnowledgeAgent)this.getKnowledgeAgentWithResponse(agentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeAgent> getKnowledgeAgentWithResponse(String agentName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeAgents().getWithResponse(agentName, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> listKnowledgeAgents() {
        return this.listKnowledgeAgents(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeAgent> listKnowledgeAgents(Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeAgents().list(null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteKnowledgeAgent(String agentName) {
        this.deleteKnowledgeAgentWithResponse(agentName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteKnowledgeAgentWithResponse(String agentName, MatchConditions matchConditions, Context context) {
        String ifMatch = matchConditions != null ? matchConditions.getIfMatch() : null;
        String ifNoneMatch = matchConditions != null ? matchConditions.getIfNoneMatch() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeAgents().deleteWithResponse(agentName, ifMatch, ifNoneMatch, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource createKnowledgeSource(KnowledgeSource knowledgeSource) {
        return (KnowledgeSource)this.createKnowledgeSourceWithResponse(knowledgeSource, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> createKnowledgeSourceWithResponse(KnowledgeSource knowledgeSource, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeSources().createWithResponse(knowledgeSource, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource createOrUpdateKnowledgeSource(KnowledgeSource knowledgeSource) {
        return (KnowledgeSource)this.createOrUpdateKnowledgeSourceWithResponse(knowledgeSource, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> createOrUpdateKnowledgeSourceWithResponse(KnowledgeSource knowledgeSource, MatchConditions matchConditions, Context context) {
        String ifMatch = matchConditions != null ? matchConditions.getIfMatch() : null;
        String ifNoneMatch = matchConditions != null ? matchConditions.getIfNoneMatch() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeSources().createOrUpdateWithResponse(knowledgeSource.getName(), knowledgeSource, ifMatch, ifNoneMatch, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KnowledgeSource getKnowledgeSource(String sourceName) {
        return (KnowledgeSource)this.getKnowledgeSourceWithResponse(sourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KnowledgeSource> getKnowledgeSourceWithResponse(String sourceName, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeSources().getWithResponse(sourceName, null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> listKnowledgeSources() {
        return this.listKnowledgeSources(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KnowledgeSource> listKnowledgeSources(Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeSources().list(null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteKnowledgeSource(String sourceName) {
        this.deleteKnowledgeSourceWithResponse(sourceName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteKnowledgeSourceWithResponse(String sourceName, MatchConditions matchConditions, Context context) {
        String ifMatch = matchConditions != null ? matchConditions.getIfMatch() : null;
        String ifNoneMatch = matchConditions != null ? matchConditions.getIfNoneMatch() : null;
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getKnowledgeSources().deleteWithResponse(sourceName, ifMatch, ifNoneMatch, null, context), LOGGER);
    }
}

