/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import java.io.IOException;

public final class KnowledgeAgentSemanticRerankerActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "semanticReranker";
    private Integer inputTokens;

    public KnowledgeAgentSemanticRerankerActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    public KnowledgeAgentSemanticRerankerActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    @Override
    public KnowledgeAgentSemanticRerankerActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", (Number)this.inputTokens);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentSemanticRerankerActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentSemanticRerankerActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "semanticReranker";
            Integer inputTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("inputTokens".equals(fieldName)) {
                    inputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentSemanticRerankerActivityRecord deserializedKnowledgeAgentSemanticRerankerActivityRecord = new KnowledgeAgentSemanticRerankerActivityRecord(id);
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.type = type;
                deserializedKnowledgeAgentSemanticRerankerActivityRecord.inputTokens = inputTokens;
                return deserializedKnowledgeAgentSemanticRerankerActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

