/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentAzureBlobActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentSearchIndexActivityRecord;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class KnowledgeAgentRetrievalActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "KnowledgeAgentRetrievalActivityRecord";
    private String knowledgeSourceName;
    private OffsetDateTime queryTime;
    private Integer count;

    public KnowledgeAgentRetrievalActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getKnowledgeSourceName() {
        return this.knowledgeSourceName;
    }

    public KnowledgeAgentRetrievalActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        this.knowledgeSourceName = knowledgeSourceName;
        return this;
    }

    public OffsetDateTime getQueryTime() {
        return this.queryTime;
    }

    public KnowledgeAgentRetrievalActivityRecord setQueryTime(OffsetDateTime queryTime) {
        this.queryTime = queryTime;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public KnowledgeAgentRetrievalActivityRecord setCount(Integer count) {
        this.count = count;
        return this;
    }

    @Override
    public KnowledgeAgentRetrievalActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("knowledgeSourceName", this.knowledgeSourceName);
        jsonWriter.writeStringField("queryTime", this.queryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queryTime));
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentRetrievalActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentRetrievalActivityRecord)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeAgentRetrievalActivityRecord knowledgeAgentRetrievalActivityRecord;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("searchIndex".equals(discriminatorValue)) {
                    knowledgeAgentRetrievalActivityRecord = KnowledgeAgentSearchIndexActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentRetrievalActivityRecord;
                }
                if ("azureBlob".equals(discriminatorValue)) {
                    knowledgeAgentRetrievalActivityRecord = KnowledgeAgentAzureBlobActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentRetrievalActivityRecord;
                }
                knowledgeAgentRetrievalActivityRecord = KnowledgeAgentRetrievalActivityRecord.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeAgentRetrievalActivityRecord;
            }
        });
    }

    static KnowledgeAgentRetrievalActivityRecord fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentRetrievalActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "KnowledgeAgentRetrievalActivityRecord";
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    continue;
                }
                if ("queryTime".equals(fieldName)) {
                    queryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentRetrievalActivityRecord deserializedKnowledgeAgentRetrievalActivityRecord = new KnowledgeAgentRetrievalActivityRecord(id);
                deserializedKnowledgeAgentRetrievalActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentRetrievalActivityRecord.type = type;
                deserializedKnowledgeAgentRetrievalActivityRecord.knowledgeSourceName = knowledgeSourceName;
                deserializedKnowledgeAgentRetrievalActivityRecord.queryTime = queryTime;
                deserializedKnowledgeAgentRetrievalActivityRecord.count = count;
                return deserializedKnowledgeAgentRetrievalActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

