/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import java.io.IOException;

public final class KnowledgeAgentModelQueryPlanningActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "modelQueryPlanning";
    private Integer inputTokens;
    private Integer outputTokens;

    public KnowledgeAgentModelQueryPlanningActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    public KnowledgeAgentModelQueryPlanningActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    public Integer getOutputTokens() {
        return this.outputTokens;
    }

    public KnowledgeAgentModelQueryPlanningActivityRecord setOutputTokens(Integer outputTokens) {
        this.outputTokens = outputTokens;
        return this;
    }

    @Override
    public KnowledgeAgentModelQueryPlanningActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", (Number)this.inputTokens);
        jsonWriter.writeNumberField("outputTokens", (Number)this.outputTokens);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentModelQueryPlanningActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentModelQueryPlanningActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "modelQueryPlanning";
            Integer inputTokens = null;
            Integer outputTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("inputTokens".equals(fieldName)) {
                    inputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("outputTokens".equals(fieldName)) {
                    outputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentModelQueryPlanningActivityRecord deserializedKnowledgeAgentModelQueryPlanningActivityRecord = new KnowledgeAgentModelQueryPlanningActivityRecord(id);
                deserializedKnowledgeAgentModelQueryPlanningActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentModelQueryPlanningActivityRecord.type = type;
                deserializedKnowledgeAgentModelQueryPlanningActivityRecord.inputTokens = inputTokens;
                deserializedKnowledgeAgentModelQueryPlanningActivityRecord.outputTokens = outputTokens;
                return deserializedKnowledgeAgentModelQueryPlanningActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

