/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import java.io.IOException;

public final class KnowledgeAgentModelAnswerSynthesisActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "modelAnswerSynthesis";
    private Integer inputTokens;
    private Integer outputTokens;

    public KnowledgeAgentModelAnswerSynthesisActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    public KnowledgeAgentModelAnswerSynthesisActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    public Integer getOutputTokens() {
        return this.outputTokens;
    }

    public KnowledgeAgentModelAnswerSynthesisActivityRecord setOutputTokens(Integer outputTokens) {
        this.outputTokens = outputTokens;
        return this;
    }

    @Override
    public KnowledgeAgentModelAnswerSynthesisActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", (Number)this.inputTokens);
        jsonWriter.writeNumberField("outputTokens", (Number)this.outputTokens);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentModelAnswerSynthesisActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentModelAnswerSynthesisActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String type = "modelAnswerSynthesis";
            Integer inputTokens = null;
            Integer outputTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("inputTokens".equals(fieldName)) {
                    inputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("outputTokens".equals(fieldName)) {
                    outputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentModelAnswerSynthesisActivityRecord deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord = new KnowledgeAgentModelAnswerSynthesisActivityRecord(id);
                deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord.type = type;
                deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord.inputTokens = inputTokens;
                deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord.outputTokens = outputTokens;
                return deserializedKnowledgeAgentModelAnswerSynthesisActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

