/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageContent;
import com.azure.search.documents.agents.models.KnowledgeAgentMessageContentType;
import java.io.IOException;

public final class KnowledgeAgentMessageTextContent
extends KnowledgeAgentMessageContent {
    private KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.TEXT;
    private final String text;

    public KnowledgeAgentMessageTextContent(String text) {
        this.text = text;
    }

    @Override
    public KnowledgeAgentMessageContentType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentMessageTextContent fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentMessageTextContent)jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            KnowledgeAgentMessageContentType type = KnowledgeAgentMessageContentType.TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = KnowledgeAgentMessageContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (textFound) {
                KnowledgeAgentMessageTextContent deserializedKnowledgeAgentMessageTextContent = new KnowledgeAgentMessageTextContent(text);
                deserializedKnowledgeAgentMessageTextContent.type = type;
                return deserializedKnowledgeAgentMessageTextContent;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}

