/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class KnowledgeAgentAzureBlobReference
extends KnowledgeAgentReference {
    private String type = "azureBlob";
    private String blobUrl;

    public KnowledgeAgentAzureBlobReference(String id, int activitySource) {
        super(id, activitySource);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getBlobUrl() {
        return this.blobUrl;
    }

    public KnowledgeAgentAzureBlobReference setBlobUrl(String blobUrl) {
        this.blobUrl = blobUrl;
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobReference setSourceData(Map<String, Object> sourceData) {
        super.setSourceData(sourceData);
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobReference setRerankerScore(Float rerankerScore) {
        super.setRerankerScore(rerankerScore);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeIntField("activitySource", this.getActivitySource());
        jsonWriter.writeMapField("sourceData", this.getSourceData(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", (Number)this.getRerankerScore());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("blobUrl", this.blobUrl);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentAzureBlobReference fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentAzureBlobReference)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            Map sourceData = null;
            Float rerankerScore = null;
            String type = "azureBlob";
            String blobUrl = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                    continue;
                }
                if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("blobUrl".equals(fieldName)) {
                    blobUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentAzureBlobReference deserializedKnowledgeAgentAzureBlobReference = new KnowledgeAgentAzureBlobReference(id, activitySource);
                deserializedKnowledgeAgentAzureBlobReference.setSourceData(sourceData);
                deserializedKnowledgeAgentAzureBlobReference.setRerankerScore(rerankerScore);
                deserializedKnowledgeAgentAzureBlobReference.type = type;
                deserializedKnowledgeAgentAzureBlobReference.blobUrl = blobUrl;
                return deserializedKnowledgeAgentAzureBlobReference;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

