/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentAzureBlobActivityArguments;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalActivityRecord;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class KnowledgeAgentAzureBlobActivityRecord
extends KnowledgeAgentRetrievalActivityRecord {
    private String type = "azureBlob";
    private KnowledgeAgentAzureBlobActivityArguments azureBlobArguments;

    public KnowledgeAgentAzureBlobActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public KnowledgeAgentAzureBlobActivityArguments getAzureBlobArguments() {
        return this.azureBlobArguments;
    }

    public KnowledgeAgentAzureBlobActivityRecord setAzureBlobArguments(KnowledgeAgentAzureBlobActivityArguments azureBlobArguments) {
        this.azureBlobArguments = azureBlobArguments;
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        super.setKnowledgeSourceName(knowledgeSourceName);
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobActivityRecord setQueryTime(OffsetDateTime queryTime) {
        super.setQueryTime(queryTime);
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobActivityRecord setCount(Integer count) {
        super.setCount(count);
        return this;
    }

    @Override
    public KnowledgeAgentAzureBlobActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("knowledgeSourceName", this.getKnowledgeSourceName());
        jsonWriter.writeStringField("queryTime", this.getQueryTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getQueryTime()));
        jsonWriter.writeNumberField("count", (Number)this.getCount());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("azureBlobArguments", (JsonSerializable)this.azureBlobArguments);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentAzureBlobActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentAzureBlobActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            String type = "azureBlob";
            KnowledgeAgentAzureBlobActivityArguments azureBlobArguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    continue;
                }
                if ("queryTime".equals(fieldName)) {
                    queryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("azureBlobArguments".equals(fieldName)) {
                    azureBlobArguments = KnowledgeAgentAzureBlobActivityArguments.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentAzureBlobActivityRecord deserializedKnowledgeAgentAzureBlobActivityRecord = new KnowledgeAgentAzureBlobActivityRecord(id);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setKnowledgeSourceName(knowledgeSourceName);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setQueryTime(queryTime);
                deserializedKnowledgeAgentAzureBlobActivityRecord.setCount(count);
                deserializedKnowledgeAgentAzureBlobActivityRecord.type = type;
                deserializedKnowledgeAgentAzureBlobActivityRecord.azureBlobArguments = azureBlobArguments;
                return deserializedKnowledgeAgentAzureBlobActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

