/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentAzureBlobActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentModelAnswerSynthesisActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentModelQueryPlanningActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentSearchIndexActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentSemanticRerankerActivityRecord;
import java.io.IOException;

public class KnowledgeAgentActivityRecord
implements JsonSerializable<KnowledgeAgentActivityRecord> {
    private String type = "KnowledgeAgentActivityRecord";
    private final int id;
    private Integer elapsedMs;

    public KnowledgeAgentActivityRecord(int id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    public KnowledgeAgentActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("elapsedMs", (Number)this.elapsedMs);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentActivityRecord)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeAgentActivityRecord knowledgeAgentActivityRecord;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("KnowledgeAgentRetrievalActivityRecord".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentRetrievalActivityRecord.fromJsonKnownDiscriminator(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                if ("searchIndex".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentSearchIndexActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                if ("azureBlob".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentAzureBlobActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                if ("modelQueryPlanning".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentModelQueryPlanningActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                if ("modelAnswerSynthesis".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentModelAnswerSynthesisActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                if ("semanticReranker".equals(discriminatorValue)) {
                    knowledgeAgentActivityRecord = KnowledgeAgentSemanticRerankerActivityRecord.fromJson(readerToUse.reset());
                    return knowledgeAgentActivityRecord;
                }
                knowledgeAgentActivityRecord = KnowledgeAgentActivityRecord.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeAgentActivityRecord;
            }
        });
    }

    static KnowledgeAgentActivityRecord fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = null;
            Integer elapsedMs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentActivityRecord deserializedKnowledgeAgentActivityRecord = new KnowledgeAgentActivityRecord(id);
                deserializedKnowledgeAgentActivityRecord.type = type;
                deserializedKnowledgeAgentActivityRecord.elapsedMs = elapsedMs;
                return deserializedKnowledgeAgentActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

