/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.agents.implementation.KnowledgeRetrievalsImpl;

public final class KnowledgeAgentRetrievalClientImpl {
    private final String endpoint;
    private final String agentName;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final KnowledgeRetrievalsImpl knowledgeRetrievals;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public KnowledgeRetrievalsImpl getKnowledgeRetrievals() {
        return this.knowledgeRetrievals;
    }

    public KnowledgeAgentRetrievalClientImpl(String endpoint, String agentName, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, agentName, apiVersion);
    }

    public KnowledgeAgentRetrievalClientImpl(HttpPipeline httpPipeline, String endpoint, String agentName, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, agentName, apiVersion);
    }

    public KnowledgeAgentRetrievalClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String agentName, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.agentName = agentName;
        this.apiVersion = apiVersion;
        this.knowledgeRetrievals = new KnowledgeRetrievalsImpl(this);
    }
}

