/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.agents.SearchKnowledgeAgentClientBuilder;
import com.azure.search.documents.agents.implementation.KnowledgeAgentRetrievalClientImpl;
import com.azure.search.documents.agents.implementation.KnowledgeRetrievalsImpl;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalRequest;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalResponse;
import com.azure.search.documents.implementation.util.MappingUtils;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchKnowledgeAgentClientBuilder.class, isAsync=true)
public final class SearchKnowledgeAgentAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchKnowledgeAgentAsyncClient.class);
    private final String endpoint;
    private final String agentName;
    private final SearchServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final KnowledgeAgentRetrievalClientImpl impl;
    private final KnowledgeRetrievalsImpl retrievals;

    SearchKnowledgeAgentAsyncClient(String endpoint, String agentName, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline) {
        this.endpoint = endpoint;
        this.agentName = agentName;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.impl = new KnowledgeAgentRetrievalClientImpl(httpPipeline, endpoint, agentName, serviceVersion.getVersion());
        this.retrievals = this.impl.getKnowledgeRetrievals();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public SearchServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KnowledgeAgentRetrievalResponse> retrieve(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization) {
        return this.retrievals.retrieveAsync(retrievalRequest, xMsQuerySourceAuthorization, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KnowledgeAgentRetrievalResponse>> retrieveWithResponse(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization) {
        return FluxUtil.withContext(context -> this.retrieveWithResponse(retrievalRequest, xMsQuerySourceAuthorization, (Context)context));
    }

    Mono<Response<KnowledgeAgentRetrievalResponse>> retrieveWithResponse(KnowledgeAgentRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization, Context context) {
        try {
            return this.retrievals.retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }
}

