/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.AutocompleteMode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class AutocompleteOptions
implements JsonSerializable<AutocompleteOptions> {
    private AutocompleteMode autocompleteMode;
    private String filter;
    private Boolean useFuzzyMatching;
    private String highlightPostTag;
    private String highlightPreTag;
    private Double minimumCoverage;
    private List<String> searchFields;
    private Integer top;

    public AutocompleteMode getAutocompleteMode() {
        return this.autocompleteMode;
    }

    public AutocompleteOptions setAutocompleteMode(AutocompleteMode autocompleteMode) {
        this.autocompleteMode = autocompleteMode;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AutocompleteOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public Boolean useFuzzyMatching() {
        return this.useFuzzyMatching;
    }

    public AutocompleteOptions setUseFuzzyMatching(Boolean useFuzzyMatching) {
        this.useFuzzyMatching = useFuzzyMatching;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public AutocompleteOptions setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public AutocompleteOptions setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Double getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public AutocompleteOptions setMinimumCoverage(Double minimumCoverage) {
        this.minimumCoverage = minimumCoverage;
        return this;
    }

    public List<String> getSearchFields() {
        return this.searchFields;
    }

    public AutocompleteOptions setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public Integer getTop() {
        return this.top;
    }

    public AutocompleteOptions setTop(Integer top) {
        this.top = top;
        return this;
    }

    public AutocompleteOptions setSearchFields(String ... searchFields) {
        this.searchFields = searchFields == null ? null : Arrays.asList(searchFields);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autocompleteMode", this.autocompleteMode == null ? null : this.autocompleteMode.toString());
        jsonWriter.writeStringField("$filter", this.filter);
        jsonWriter.writeBooleanField("UseFuzzyMatching", this.useFuzzyMatching);
        jsonWriter.writeStringField("highlightPostTag", this.highlightPostTag);
        jsonWriter.writeStringField("highlightPreTag", this.highlightPreTag);
        jsonWriter.writeNumberField("minimumCoverage", (Number)this.minimumCoverage);
        jsonWriter.writeArrayField("searchFields", this.searchFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("$top", (Number)this.top);
        return jsonWriter.writeEndObject();
    }

    public static AutocompleteOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AutocompleteOptions)jsonReader.readObject(reader -> {
            AutocompleteOptions deserializedAutocompleteOptions = new AutocompleteOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autocompleteMode".equals(fieldName)) {
                    deserializedAutocompleteOptions.autocompleteMode = AutocompleteMode.fromString(reader.getString());
                    continue;
                }
                if ("$filter".equals(fieldName)) {
                    deserializedAutocompleteOptions.filter = reader.getString();
                    continue;
                }
                if ("UseFuzzyMatching".equals(fieldName)) {
                    deserializedAutocompleteOptions.useFuzzyMatching = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("highlightPostTag".equals(fieldName)) {
                    deserializedAutocompleteOptions.highlightPostTag = reader.getString();
                    continue;
                }
                if ("highlightPreTag".equals(fieldName)) {
                    deserializedAutocompleteOptions.highlightPreTag = reader.getString();
                    continue;
                }
                if ("minimumCoverage".equals(fieldName)) {
                    deserializedAutocompleteOptions.minimumCoverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("searchFields".equals(fieldName)) {
                    List searchFields;
                    deserializedAutocompleteOptions.searchFields = searchFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("$top".equals(fieldName)) {
                    deserializedAutocompleteOptions.top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutocompleteOptions;
        });
    }
}

