/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SemanticConfiguration;
import java.io.IOException;
import java.util.List;

public final class SemanticSearch
implements JsonSerializable<SemanticSearch> {
    private String defaultConfigurationName;
    private List<SemanticConfiguration> configurations;

    public String getDefaultConfigurationName() {
        return this.defaultConfigurationName;
    }

    public SemanticSearch setDefaultConfigurationName(String defaultConfigurationName) {
        this.defaultConfigurationName = defaultConfigurationName;
        return this;
    }

    public List<SemanticConfiguration> getConfigurations() {
        return this.configurations;
    }

    public SemanticSearch setConfigurations(List<SemanticConfiguration> configurations) {
        this.configurations = configurations;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultConfiguration", this.defaultConfigurationName);
        jsonWriter.writeArrayField("configurations", this.configurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SemanticSearch fromJson(JsonReader jsonReader) throws IOException {
        return (SemanticSearch)jsonReader.readObject(reader -> {
            SemanticSearch deserializedSemanticSearch = new SemanticSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultConfiguration".equals(fieldName)) {
                    deserializedSemanticSearch.defaultConfigurationName = reader.getString();
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    List configurations;
                    deserializedSemanticSearch.configurations = configurations = reader.readArray(reader1 -> SemanticConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSemanticSearch;
        });
    }
}

