/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SemanticField;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class SemanticPrioritizedFields
implements JsonSerializable<SemanticPrioritizedFields> {
    private SemanticField titleField;
    private List<SemanticField> contentFields;
    private List<SemanticField> keywordsFields;

    public SemanticField getTitleField() {
        return this.titleField;
    }

    public SemanticPrioritizedFields setTitleField(SemanticField titleField) {
        this.titleField = titleField;
        return this;
    }

    public List<SemanticField> getContentFields() {
        return this.contentFields;
    }

    public SemanticPrioritizedFields setContentFields(List<SemanticField> contentFields) {
        this.contentFields = contentFields;
        return this;
    }

    public List<SemanticField> getKeywordsFields() {
        return this.keywordsFields;
    }

    public SemanticPrioritizedFields setKeywordsFields(List<SemanticField> keywordsFields) {
        this.keywordsFields = keywordsFields;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("titleField", (JsonSerializable)this.titleField);
        jsonWriter.writeArrayField("prioritizedContentFields", this.contentFields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("prioritizedKeywordsFields", this.keywordsFields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SemanticPrioritizedFields fromJson(JsonReader jsonReader) throws IOException {
        return (SemanticPrioritizedFields)jsonReader.readObject(reader -> {
            SemanticPrioritizedFields deserializedSemanticPrioritizedFields = new SemanticPrioritizedFields();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("titleField".equals(fieldName)) {
                    deserializedSemanticPrioritizedFields.titleField = SemanticField.fromJson(reader);
                    continue;
                }
                if ("prioritizedContentFields".equals(fieldName)) {
                    List contentFields;
                    deserializedSemanticPrioritizedFields.contentFields = contentFields = reader.readArray(reader1 -> SemanticField.fromJson(reader1));
                    continue;
                }
                if ("prioritizedKeywordsFields".equals(fieldName)) {
                    List keywordsFields;
                    deserializedSemanticPrioritizedFields.keywordsFields = keywordsFields = reader.readArray(reader1 -> SemanticField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSemanticPrioritizedFields;
        });
    }

    public SemanticPrioritizedFields setContentFields(SemanticField ... contentFields) {
        this.contentFields = contentFields == null ? null : Arrays.asList(contentFields);
        return this;
    }

    public SemanticPrioritizedFields setKeywordsFields(SemanticField ... keywordsFields) {
        this.keywordsFields = keywordsFields == null ? null : Arrays.asList(keywordsFields);
        return this;
    }
}

