/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.DataSourceCredentials;
import com.azure.search.documents.indexes.models.DataChangeDetectionPolicy;
import com.azure.search.documents.indexes.models.DataDeletionDetectionPolicy;
import com.azure.search.documents.indexes.models.SearchIndexerDataContainer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceType;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;

public final class SearchIndexerDataSourceConnection
implements JsonSerializable<SearchIndexerDataSourceConnection> {
    private final String name;
    private String description;
    private SearchIndexerDataSourceType type;
    private DataSourceCredentials credentials;
    private SearchIndexerDataContainer container;
    private DataChangeDetectionPolicy dataChangeDetectionPolicy;
    private DataDeletionDetectionPolicy dataDeletionDetectionPolicy;
    private String eTag;
    private SearchResourceEncryptionKey encryptionKey;

    public SearchIndexerDataSourceConnection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexerDataSourceConnection setDescription(String description) {
        this.description = description;
        return this;
    }

    public SearchIndexerDataSourceType getType() {
        return this.type;
    }

    public SearchIndexerDataSourceConnection setType(SearchIndexerDataSourceType type) {
        this.type = type;
        return this;
    }

    public SearchIndexerDataContainer getContainer() {
        return this.container;
    }

    public SearchIndexerDataSourceConnection setContainer(SearchIndexerDataContainer container) {
        this.container = container;
        return this;
    }

    public DataChangeDetectionPolicy getDataChangeDetectionPolicy() {
        return this.dataChangeDetectionPolicy;
    }

    public SearchIndexerDataSourceConnection setDataChangeDetectionPolicy(DataChangeDetectionPolicy dataChangeDetectionPolicy) {
        this.dataChangeDetectionPolicy = dataChangeDetectionPolicy;
        return this;
    }

    public DataDeletionDetectionPolicy getDataDeletionDetectionPolicy() {
        return this.dataDeletionDetectionPolicy;
    }

    public SearchIndexerDataSourceConnection setDataDeletionDetectionPolicy(DataDeletionDetectionPolicy dataDeletionDetectionPolicy) {
        this.dataDeletionDetectionPolicy = dataDeletionDetectionPolicy;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndexerDataSourceConnection setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SearchIndexerDataSourceConnection setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeJsonField("container", (JsonSerializable)this.container);
        jsonWriter.writeJsonField("dataChangeDetectionPolicy", (JsonSerializable)this.dataChangeDetectionPolicy);
        jsonWriter.writeJsonField("dataDeletionDetectionPolicy", (JsonSerializable)this.dataDeletionDetectionPolicy);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerDataSourceConnection fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerDataSourceConnection)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            SearchIndexerDataSourceType type = null;
            DataSourceCredentials credentials = null;
            SearchIndexerDataContainer container = null;
            DataChangeDetectionPolicy dataChangeDetectionPolicy = null;
            DataDeletionDetectionPolicy dataDeletionDetectionPolicy = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = SearchIndexerDataSourceType.fromString(reader.getString());
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    credentials = DataSourceCredentials.fromJson(reader);
                    continue;
                }
                if ("container".equals(fieldName)) {
                    container = SearchIndexerDataContainer.fromJson(reader);
                    continue;
                }
                if ("dataChangeDetectionPolicy".equals(fieldName)) {
                    dataChangeDetectionPolicy = DataChangeDetectionPolicy.fromJson(reader);
                    continue;
                }
                if ("dataDeletionDetectionPolicy".equals(fieldName)) {
                    dataDeletionDetectionPolicy = DataDeletionDetectionPolicy.fromJson(reader);
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                SearchIndexerDataSourceConnection deserializedSearchIndexerDataSourceConnection = new SearchIndexerDataSourceConnection(name);
                deserializedSearchIndexerDataSourceConnection.description = description;
                deserializedSearchIndexerDataSourceConnection.type = type;
                deserializedSearchIndexerDataSourceConnection.credentials = credentials;
                deserializedSearchIndexerDataSourceConnection.container = container;
                deserializedSearchIndexerDataSourceConnection.dataChangeDetectionPolicy = dataChangeDetectionPolicy;
                deserializedSearchIndexerDataSourceConnection.dataDeletionDetectionPolicy = dataDeletionDetectionPolicy;
                deserializedSearchIndexerDataSourceConnection.eTag = eTag;
                deserializedSearchIndexerDataSourceConnection.encryptionKey = encryptionKey;
                return deserializedSearchIndexerDataSourceConnection;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public SearchIndexerDataSourceConnection(String name, SearchIndexerDataSourceType type, String connectionString, SearchIndexerDataContainer container) {
        this.name = name;
        this.type = type;
        this.credentials = connectionString == null ? null : new DataSourceCredentials().setConnectionString(connectionString);
        this.container = container;
    }

    public String getConnectionString() {
        return this.credentials == null ? null : this.credentials.getConnectionString();
    }

    public SearchIndexerDataSourceConnection setConnectionString(String connectionString) {
        if (connectionString == null) {
            this.credentials = null;
        } else if (this.credentials == null) {
            this.credentials = new DataSourceCredentials().setConnectionString(connectionString);
        } else {
            this.credentials.setConnectionString(connectionString);
        }
        return this;
    }
}

